/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.adaptor.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import mx4j.tools.adaptor.http.HttpException;
import mx4j.tools.adaptor.http.HttpUtil;

public class HttpInputStream
extends BufferedInputStream {
    private String method;
    private String path;
    private String queryString;
    private float version;
    private Map headers = new HashMap();
    private Map variables = new HashMap();

    public HttpInputStream(InputStream in) {
        super(in);
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public float getVersion() {
        return this.version;
    }

    public String getHeader(String name) {
        return (String)this.headers.get(name);
    }

    public Map getHeaders() {
        return this.headers;
    }

    public void readRequest() throws IOException {
        String request = this.readLine();
        if (request == null) {
            throw new HttpException(400, "Null query");
        }
        StringTokenizer parts = new StringTokenizer(request);
        try {
            this.parseMethod(parts.nextToken());
            this.parseRequest(parts.nextToken());
        }
        catch (NoSuchElementException ex) {
            throw new HttpException(400, request);
        }
        if (parts.hasMoreTokens()) {
            this.parseVersion(parts.nextToken());
        } else {
            this.version = 0.9f;
        }
        if (this.version >= 1.0f) {
            this.readHeaders();
            this.parseVariables();
        }
    }

    public String readLine() throws IOException {
        int c;
        StringBuffer line = new StringBuffer(64);
        line.delete(0, line.length());
        while ((c = this.read()) != -1 && c != 10 && c != 13) {
            line.append((char)c);
        }
        if (c == 13 && (c = this.read()) != 10 && c != -1) {
            --this.pos;
        }
        if (c == -1 && line.length() == 0) {
            return null;
        }
        return line.toString();
    }

    public Map getVariables() {
        return this.variables;
    }

    public String getVariable(String name) {
        if (this.variables.containsKey(name)) {
            Object variable = this.variables.get(name);
            if (variable instanceof String) {
                return (String)variable;
            }
            if (variable instanceof String[]) {
                return ((String[])variable)[0];
            }
        }
        return null;
    }

    public String[] getVariableValues(String name) {
        if (this.variables.containsKey(name)) {
            Object variable = this.variables.get(name);
            if (variable instanceof String[]) {
                return (String[])variable;
            }
            if (variable instanceof String) {
                String[] result = new String[]{(String)variable};
                return result;
            }
        }
        return null;
    }

    protected void parseVariables() throws HttpException {
        try {
            String variableHolder = "";
            if (this.method.equals("POST") && "application/x-www-form-urlencoded".equals(this.headers.get("content-type")) && this.headers.get("content-length") != null) {
                if ("chunked".equals(this.headers.get("transfer-encoding"))) {
                    throw new HttpException(400, "Sorry I don't understand chunked requests");
                }
                StringBuffer buffer = new StringBuffer();
                int size = Integer.parseInt((String)this.headers.get("content-length"));
                this.mark(size);
                for (int i = 0; i < size; ++i) {
                    int j = this.read();
                    if (j < 0) {
                        throw new HttpException(400, "Request not understood");
                    }
                    buffer.append((char)j);
                }
                variableHolder = buffer.toString();
                this.reset();
            } else if (this.method.equals("GET")) {
                variableHolder = this.getQueryString();
            } else {
                throw new HttpException(400, "Request not understood");
            }
            StringTokenizer parser = new StringTokenizer(variableHolder, "&");
            while (parser.hasMoreTokens()) {
                String command = parser.nextToken();
                int equalIndex = command.indexOf(61);
                if (equalIndex <= 0) continue;
                String variableName = URLDecoder.decode(command.substring(0, equalIndex));
                String variableValue = URLDecoder.decode(command.substring(equalIndex + 1, command.length()));
                variableValue = new String(variableValue.getBytes(), "UTF-8");
                if (this.variables.get(variableName) != null) {
                    Object value = this.variables.get(variableName);
                    String[] newValue = null;
                    if (value instanceof String) {
                        newValue = new String[]{variableValue, (String)value};
                    } else {
                        String[] oldValue = (String[])value;
                        newValue = new String[oldValue.length + 1];
                        System.arraycopy(oldValue, 0, newValue, 1, oldValue.length);
                        newValue[0] = variableValue;
                    }
                    this.variables.put(variableName, newValue);
                    continue;
                }
                this.variables.put(variableName, variableValue);
            }
        }
        catch (Exception e) {
            throw new HttpException(400, this.getQueryString());
        }
    }

    protected void parseMethod(String method) throws HttpException {
        if (method.equals("GET")) {
            this.method = "GET";
        } else if (method.equals("POST")) {
            this.method = "POST";
        } else {
            throw new HttpException(501, method);
        }
    }

    protected void parseRequest(String request) throws HttpException {
        if (!request.startsWith("/")) {
            throw new HttpException(400, request);
        }
        int queryIdx = request.indexOf(63);
        if (queryIdx == -1) {
            this.path = HttpUtil.canonicalizePath(request);
            this.queryString = "";
        } else {
            this.path = HttpUtil.canonicalizePath(request.substring(0, queryIdx));
            this.queryString = request.substring(queryIdx + 1);
        }
    }

    protected void parseVersion(String verStr) throws HttpException {
        if (!verStr.startsWith("HTTP/")) {
            throw new HttpException(400, verStr);
        }
        try {
            this.version = Float.valueOf(verStr.substring(5)).floatValue();
        }
        catch (NumberFormatException ex) {
            throw new HttpException(400, verStr);
        }
    }

    protected void readHeaders() throws IOException {
        String header;
        while ((header = this.readLine()) != null && !header.equals("")) {
            int colonIdx = header.indexOf(58);
            if (colonIdx == -1) continue;
            String name = header.substring(0, colonIdx);
            String value = header.substring(colonIdx + 1);
            this.headers.put(name.toLowerCase(), value.trim());
        }
    }
}

