/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.testing.drivers;

import com.opera.core.systems.OperaProduct;
import com.opera.core.systems.OperaSettings;
import com.opera.core.systems.testing.drivers.TestDriverSupplier;
import java.util.logging.Level;

public abstract class AbstractTestDriverSupplier
implements TestDriverSupplier {
    protected OperaSettings settings;
    private final OperaProduct product;

    public AbstractTestDriverSupplier() {
        this(new OperaSettings());
    }

    public AbstractTestDriverSupplier(OperaProduct product) {
        this(new OperaSettings.Builder().product(product).get());
    }

    public AbstractTestDriverSupplier(OperaSettings settings) {
        this.setSettings(settings);
        this.product = settings.getProduct();
    }

    @Override
    public void setSettings(OperaSettings newSettings) {
        this.settings = newSettings;
        if (new OperaSettings().logging().getLevel() == this.settings.logging().getLevel()) {
            this.settings.logging().setLevel(Level.INFO);
        }
    }

    @Override
    public OperaSettings getSettings() {
        this.settings.setProduct(this.product);
        return this.settings;
    }
}

