/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.NodeFilter;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.w3c.dom.DOMException;

@JsxClass
public class TreeWalker
extends SimpleScriptable {
    private Node root_;
    private Node currentNode_;
    private long whatToShow_;
    private NodeFilter filter_;
    private boolean expandEntityReferences_;

    public TreeWalker() {
    }

    public TreeWalker(Node root, long whatToShow, NodeFilter filter, boolean expandEntityReferences) throws DOMException {
        if (root == null) {
            Context.throwAsScriptRuntimeEx(new DOMException(9, "root must not be null"));
        }
        this.root_ = root;
        this.whatToShow_ = whatToShow;
        this.filter_ = filter;
        this.expandEntityReferences_ = expandEntityReferences;
        this.currentNode_ = this.root_;
    }

    @JsxGetter
    public Node getRoot() {
        return this.root_;
    }

    @JsxGetter
    public long getWhatToShow() {
        if (this.whatToShow_ != 0xFFFFFFFFL) {
            return 1L;
        }
        return this.whatToShow_;
    }

    @JsxGetter
    public NodeFilter getFilter() {
        return this.filter_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF, maxVersion=20.0f), @WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public boolean getExpandEntityReferences() {
        return this.expandEntityReferences_;
    }

    @JsxGetter
    public Node getCurrentNode() {
        return this.currentNode_;
    }

    @JsxSetter
    public void setCurrentNode(Node currentNode) throws DOMException {
        if (currentNode == null) {
            throw new DOMException(9, "currentNode cannot be set to null");
        }
        this.currentNode_ = currentNode;
    }

    private static int getFlagForNodeType(short type) {
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 16;
            }
            case 6: {
                return 32;
            }
            case 7: {
                return 64;
            }
            case 8: {
                return 128;
            }
            case 9: {
                return 256;
            }
            case 10: {
                return 512;
            }
            case 11: {
                return 1024;
            }
            case 12: {
                return 2048;
            }
        }
        return 0;
    }

    private short acceptNode(Node n) {
        short type = n.getNodeType();
        int flag = TreeWalker.getFlagForNodeType(type);
        if ((this.whatToShow_ & (long)flag) != 0L) {
            return 1;
        }
        return 3;
    }

    private boolean isNodeVisible(Node n) {
        if (this.acceptNode(n) == 1 && (this.filter_ == null || this.filter_.acceptNode(n) == 1)) {
            return this.expandEntityReferences_ || n.getParent() == null || n.getParent().getNodeType() != 5;
        }
        return false;
    }

    private boolean isNodeRejected(Node n) {
        if (this.acceptNode(n) == 2) {
            return true;
        }
        if (this.filter_ != null && this.filter_.acceptNode(n) == 2) {
            return true;
        }
        return !this.expandEntityReferences_ && n.getParent() != null && n.getParent().getNodeType() == 5;
    }

    private boolean isNodeSkipped(Node n) {
        return !this.isNodeVisible(n) && !this.isNodeRejected(n);
    }

    @JsxFunction
    public Node parentNode() {
        if (this.currentNode_ == this.root_) {
            return null;
        }
        Node newNode = this.currentNode_;
        while ((newNode = newNode.getParent()) != null && !this.isNodeVisible(newNode) && newNode != this.root_) {
        }
        if (newNode == null || !this.isNodeVisible(newNode)) {
            return null;
        }
        this.currentNode_ = newNode;
        return newNode;
    }

    private Node getEquivalentLogical(Node n, boolean lookLeft) {
        Node child;
        if (n == null) {
            return null;
        }
        if (this.isNodeVisible(n)) {
            return n;
        }
        if (this.isNodeSkipped(n) && (child = lookLeft ? this.getEquivalentLogical(n.getLastChild(), lookLeft) : this.getEquivalentLogical(n.getFirstChild(), lookLeft)) != null) {
            return child;
        }
        return this.getSibling(n, lookLeft);
    }

    private Node getSibling(Node n, boolean lookLeft) {
        if (n == null) {
            return null;
        }
        if (this.isNodeVisible(n)) {
            return null;
        }
        Node sibling = lookLeft ? n.getPreviousSibling() : n.getNextSibling();
        if (sibling == null) {
            if (n == this.root_) {
                return null;
            }
            return this.getSibling(n.getParent(), lookLeft);
        }
        return this.getEquivalentLogical(sibling, lookLeft);
    }

    @JsxFunction
    public Node firstChild() {
        Node newNode = this.getEquivalentLogical(this.currentNode_.getFirstChild(), false);
        if (newNode != null) {
            this.currentNode_ = newNode;
        }
        return newNode;
    }

    @JsxFunction
    public Node lastChild() {
        Node newNode = this.getEquivalentLogical(this.currentNode_.getLastChild(), true);
        if (newNode != null) {
            this.currentNode_ = newNode;
        }
        return newNode;
    }

    @JsxFunction
    public Node previousSibling() {
        if (this.currentNode_ == this.root_) {
            return null;
        }
        Node newNode = this.getEquivalentLogical(this.currentNode_.getPreviousSibling(), true);
        if (newNode != null) {
            this.currentNode_ = newNode;
        }
        return newNode;
    }

    @JsxFunction
    public Node nextSibling() {
        if (this.currentNode_ == this.root_) {
            return null;
        }
        Node newNode = this.getEquivalentLogical(this.currentNode_.getNextSibling(), false);
        if (newNode != null) {
            this.currentNode_ = newNode;
        }
        return newNode;
    }

    @JsxFunction
    public Node previousNode() {
        Node newNode = this.getPreviousNode(this.currentNode_);
        if (newNode != null) {
            this.currentNode_ = newNode;
        }
        return newNode;
    }

    private Node getPreviousNode(Node n) {
        Node toFollow;
        if (n == this.root_) {
            return null;
        }
        Node left = this.getEquivalentLogical(n.getPreviousSibling(), true);
        if (left == null) {
            Node parent = n.getParent();
            if (parent == null) {
                return null;
            }
            if (this.isNodeVisible(parent)) {
                return parent;
            }
        }
        Node follow = left;
        while (follow.hasChildNodes() && (toFollow = this.getEquivalentLogical(follow.getLastChild(), true)) != null) {
            follow = toFollow;
        }
        return follow;
    }

    @JsxFunction
    public Node nextNode() {
        Node leftChild = this.getEquivalentLogical(this.currentNode_.getFirstChild(), false);
        if (leftChild != null) {
            this.currentNode_ = leftChild;
            return leftChild;
        }
        Node rightSibling = this.getEquivalentLogical(this.currentNode_.getNextSibling(), false);
        if (rightSibling != null) {
            this.currentNode_ = rightSibling;
            return rightSibling;
        }
        Node uncle = this.getFirstUncleNode(this.currentNode_);
        if (uncle != null) {
            this.currentNode_ = uncle;
            return uncle;
        }
        return null;
    }

    private Node getFirstUncleNode(Node n) {
        if (n == this.root_ || n == null) {
            return null;
        }
        Node parent = n.getParent();
        if (parent == null) {
            return null;
        }
        Node uncle = this.getEquivalentLogical(parent.getNextSibling(), false);
        if (uncle != null) {
            return uncle;
        }
        return this.getFirstUncleNode(parent);
    }
}

