/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.activex.javascript.msxml;

import com.gargoylesoftware.htmlunit.activex.javascript.msxml.MSXMLJavaScriptEnvironment;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MSXMLScriptable
extends SimpleScriptable {
    private static final Log LOG = LogFactory.getLog(MSXMLScriptable.class);
    private MSXMLJavaScriptEnvironment environment_;

    @Override
    public void setParentScope(Scriptable m) {
        super.setParentScope(m);
        if (m instanceof MSXMLScriptable) {
            this.setEnvironment(((MSXMLScriptable)m).getEnvironment());
        }
    }

    @Override
    public SimpleScriptable makeScriptableFor(DomNode domNode) {
        MSXMLScriptable scriptable;
        Class<? extends MSXMLScriptable> javaScriptClass = null;
        for (Class<?> c = domNode.getClass(); javaScriptClass == null && c != null; c = c.getSuperclass()) {
            javaScriptClass = this.getEnvironment().getJavaScriptClass(c);
        }
        if (javaScriptClass == null) {
            scriptable = new XMLDOMElement();
            if (LOG.isDebugEnabled()) {
                LOG.debug("No MSXML JavaScript class found for element <" + domNode.getNodeName() + ">. Using XMLDOMElement");
            }
        } else {
            try {
                scriptable = (MSXMLScriptable)javaScriptClass.newInstance();
            }
            catch (Exception e) {
                throw Context.throwAsScriptRuntimeEx(e);
            }
        }
        this.initParentScope(domNode, scriptable);
        scriptable.setPrototype(this.getPrototype(javaScriptClass));
        scriptable.setDomNode(domNode);
        scriptable.setEnvironment(this.getEnvironment());
        return scriptable;
    }

    @Override
    protected Scriptable getPrototype(Class<? extends SimpleScriptable> javaScriptClass) {
        Scriptable prototype = this.getEnvironment().getPrototype(javaScriptClass);
        if (prototype == null && javaScriptClass != SimpleScriptable.class) {
            return this.getPrototype(javaScriptClass.getSuperclass());
        }
        return prototype;
    }

    @Override
    public String getClassName() {
        return "Object";
    }

    public MSXMLJavaScriptEnvironment getEnvironment() {
        return this.environment_;
    }

    public void setEnvironment(MSXMLJavaScriptEnvironment environment) {
        this.environment_ = environment;
    }
}

