@echo off
cls
setLocal EnableDelayedExpansion
rem Get the running directory for later ease of use
SET running_directory=%~dp0
rem Set where this file will install the rest of the files
SET "location=%1"
IF NOT [!location!]==[] (
    SET install_location=!location:"=!
) else (
    SET "install_location=%APPDATA%\CIRCLE"
)

rem Set where this file will install the .rdp folder
SET "run_location=%2"
IF NOT [!run_location!]==[] (
    SET running_location=!run_location:"=!
) else (
    SET "running_location=%APPDATA%\CIRCLE"
)

rem Set whether we want output info on screen or not
IF NOT [%3]==[] (
    SET "output_on_screen=%3"
) else (
    SET "output_on_screen=True"
)
rem Set whether we want to install NX Client or not
IF NOT [%4]==[] (
    SET "install_nx=%4"
) else (
    SET "install_nx=False"
)
if NOT "!install_nx!"=="False" (
    SET "nx_install= -n"
)

rem Set which website should the icon point to
SET "site=^"http://cloud.bme.hu/^""
IF NOT [%5]==[] (
    SET site=%5
)
SET my_site=!site:"=!
SET "website= -t ^"!my_site!^""

rem Set Python bit count (32 or 64) if we know it
IF NOT [%6]==[] (
    SET "architecture=%6"
) else (
    SET "architecture="
)

rem Set Python version if we know it
IF NOT [%7]==[] (
    SET "version=%7"
) else (
    SET "version="
)

rem Set Python location if we know it
SET "python_location=%8"
IF NOT [!python_location!]==[] (
    SET install_path=!python_location:"=!
) else (
    SET "install_path="
)

:BatchCheckElevated
:-------------------------------------
REM  --> Check for permissions
>nul 2>&1 "%SYSTEMROOT%\system32\cacls.exe" "%SYSTEMROOT%\system32\config\system"

REM --> If error flag set, we do not have admin.
if '%errorlevel%' NEQ '0' (
    IF NOT "!output_on_screen!"=="False" (
        @echo Requesting administrative privileges...>CON
    )
    @echo Requesting administrative privileges...
    goto UACPrompt
) else ( goto gotAdmin )

:UACPrompt
    echo Set UAC = CreateObject^("Shell.Application"^) > ^"%temp%\getadmin.vbs^"
    set vbs_site=!site:"=""!
    set vbs_installpath=!python_location:"=""!
    echo UAC.ShellExecute "cmd.exe", "/c %~s0 !install_location! !output_on_screen! !install_nx! !vbs_site! !architecture! !version! !vbs_installpath!", "", "runas", 1 >> "%temp%\getadmin.vbs"

    ^"%temp%\getadmin.vbs^"
    del "%temp%\getadmin.vbs"
    exit /B

:gotAdmin
    pushd "%CD%"
    CD /D "%~dp0"
    IF NOT "!output_on_screen!"=="False" (
        @echo Elevated rights recived from UAC>CON
    )
    @echo Elevated rights recived from UAC
:--------------------------------------

rem Start the installation script
IF NOT "!output_on_screen!"=="False" (
    @echo Starting CIRCLE Client install script>CON
    @echo.>CON
)
@echo Starting CIRCLE Client install script
@echo.
IF NOT "!install_path!"=="" (
    IF NOT "!output_on_screen!"=="False" (
        @echo Python location got from input parameter.>CON
    )
    @echo Python location got from input parameter.
    GOTO HASPYTHON
)
if "!architecture!"=="" (
    call :SUB_ARCHITECTURE architecture
)
:PYTHON_CHECK_MODULE
rem Decide whether python 2.x is installed or not
SET "python_registry="
:PYTHON_CHECK
SET index=8
:loop
    SET /a index-=1
    IF %index% LSS 6 (
        if "!architecture!"=="64" (
			if "%python_registry%"=="" (
				SET "python_registry=Wow6432Node\"
				GOTO PYTHON_CHECK
			) else (
				GOTO NOPYTHON
			)
        ) else (
			GOTO NOPYTHON
		)
    )
    SET version=2.%index%
    SET @query="hklm\SOFTWARE\%python_registry%Python\PythonCore\!version!"
    reg>nul query %@query% 2>nul
    IF ERRORLEVEL 1 GOTO loop
    IF ERRORLEVEL 0 GOTO HASPYTHON
    pause
GOTO NOPYTHON

rem No 2.6+ Python is installed
:NOPYTHON
IF NOT "!output_on_screen!"=="False" (
    @echo No 2.6^+ Python is detected on the system.>CON
)
 @echo No 2.6^+ Python is detected on the system.
 if "!architecture!"=="64" (
    IF NOT "!output_on_screen!"=="False" (
        @echo 	64 bit system detected, commencing the install>CON
    )
    @echo 	64 bit system detected, commencing the install
    start "Python Installer" /WAIT ^"!running_directory!x64^\python-2.7.10.amd64.msi^"
    GOTO NOWHASPYTHON
 )
 if "!architecture!"=="32" (
    IF NOT "!output_on_screen!"=="False" (
        @echo 	32 bit system detected, commencing the install>CON
    )
    @echo 	32 bit system detected, commencing the install
    start "Python Installer" /WAIT ^"!running_directory!x86^\python-2.7.10.msi^"
    GOTO NOWHASPYTHON
 )
 GOTO ERR
 
 rem Subroutine to decide whether it is 32 or 64 bit
 :SUB_ARCHITECTURE
 rem Decide what architecture the system is using
 if /i "%processor_architecture%"=="AMD64" (
    SET %1=64
    GOTO END
 )
 if /i "%PROCESSOR_ARCHITEW6432%"=="AMD64" (
    SET %1=64
    GOTO END
 )
 if /i "%processor_architecture%"=="x86" (
    SET %1=32
    GOTO END
 )
 GOTO ERR
 
 rem Error within the installation
 :ERR
 IF NOT "!output_on_screen!"=="False" (
     @echo Unsupported architecture! Please install files manually>CON
     @echo Please visit: https://www.python.org/downloads/>CON
     @echo Please visit: http://www.mozilla.org/en/firefox/new/>CON
     pause
 )
 @echo Unsupported architecture! Please install files manually 1>&2
 @echo Please visit: https://www.python.org/downloads/ 1>&2
 @echo Please visit: http://www.mozilla.org/en/firefox/new/ 1>&2
 GOTO END
 
 rem The install program closed. Check whether the Python installation was successful
 :NOWHASPYTHON
 SET version=2.7
 IF NOT "!output_on_screen!"=="False" (
    @echo Python install finished, rechecking registry>CON
 )
 @echo Python install finished, rechecking registry
 GOTO PYTHON_CHECK_MODULE
 
 rem We have Python but let's check if it's in the PATH
 :HASPYTHON
    IF NOT "!output_on_screen!"=="False" (
        @echo !version! Python is found, checking PATH variable>CON
    )
    @echo !version! Python is found, checking PATH variable
    rem Check Python install path
    IF "!install_path!"=="" (
        for /f "tokens=2,*" %%a in ('reg query "hklm\SOFTWARE\%python_registry%Python\PythonCore\!version!\InstallPath"') do (
            set install_path=%%b
        )
    )
    rem Check whether python.exe is in the install path (python uninstall doesn't delete registry entrys)
    if NOT EXIST "!install_path!python.exe" (
        IF NOT "!output_on_screen!"=="False" (
            @echo   !version! Python was installed but it is NOT now. Restarting the search for python^^!>CON
        )
        @echo   !version! Python was installed but it is NOT now. Restarting the search for python^^!
        goto loop
    ) else (
        IF "!python_registry!"=="Wow6432Node\" (
            SET "architecture=32"
        )
        set test=%install_path:~0,-1%
        call ^"!running_directory!inPath^" ^"test^" && (IF NOT "!output_on_screen!"=="False" (@echo 	!test! is already in PATH>CON) && @echo 	!test! is already in PATH) || (call ^"!running_directory!addPath^" ^"test^" &  setx>nul PATH "%PATH%;!test!" /m & IF NOT "!output_on_screen!"=="False" ( @echo 	!test! set to PATH>CON) && @echo 	!test! set to PATH)
        set test=%install_path%Scripts
        call ^"!running_directory!inPath^" ^"test^" && (IF NOT "!output_on_screen!"=="False" (@echo 	!test! is already in PATH>CON) && @echo 	!test! is already in PATH) || (call ^"!running_directory!addPath^" ^"test^" &  setx>nul PATH "%PATH%;!test!" /m & IF NOT "!output_on_screen!"=="False" ( @echo 	!test! set to PATH>CON) && @echo 	!test! set to PATH)
    )
 GOTO PIP_INSTALL

 :INSTALL_EASY_INSTALL
 IF NOT "!output_on_screen!"=="False" (
    @echo   Failed. Commencing installation of easy_install>CON
 )
 @echo   Failed. Commencing installation of easy_install
 CALL python ^"!running_directory!ez_setup.py^"
 IF NOT "!output_on_screen!"=="False" (
    @echo  Done.>CON
 )
 @echo       Done.
 GOTO PIP_INSTALL
 
 :PIP_INSTALL
 IF NOT "!output_on_screen!"=="False" (
    @echo Commencing PIP reinstall to solve compatibility issues>CON
 )
 @echo Commencing PIP reinstall to solve compatibility issues
 CALL easy_install pip

 IF ERRORLEVEL 1 GOTO INSTALL_EASY_INSTALL
 SET "pip_program=requirements.txt"
 IF NOT "!output_on_screen!"=="False" (
    @echo Installing python modules>CON
 )
 @echo Installing python modules
 GOTO PIP_PACKAGE_INSTALL
 
  rem Check if the PIP package is installed or not
 :PIP_PACKAGE_CHECK
 IF NOT "!output_on_screen!"=="False" (
     @echo.>CON
     @echo Check whether !pip_program! is installed>CON
 )
 @echo.
 @echo Check whether !pip_program! is installed
 for /f "tokens=1,2 delims===" %%a in ('call python -m pip freeze') do (
    if "%%a"=="!pip_program!" (
        IF NOT "!output_on_screen!"=="False" (
            @echo 	%%b !pip_program! is found>CON
        )
        @echo 	%%b !pip_program! is found
        GOTO CHECK_PACKAGE_LIST
    )
 )
 IF NOT "!output_on_screen!"=="False" (
    @echo No !pip_program! version is found, commencing install>CON
 )
 @echo No !pip_program! version is found, commencing install
 GOTO PIP_PACKAGE_INSTALL
 
 rem Try to install the PIP packages via PIP
 :PIP_PACKAGE_INSTALL
 if "!pip_program!"=="pywin32" (
    call python ^"!running_directory!pywin_installer.py^" ^-m !architecture!
 ) else (
    call python -m pip install -r !pip_program!
 )
 goto CHECK_PACKAGE_LIST
 
 :CHECK_PACKAGE_LIST
 if "!pip_program!"=="requirements.txt" (
    set "pip_program=pywin32"
    goto PIP_PACKAGE_CHECK
 )
 goto FIN
 

rem Finish up the install
:FIN
rem Create folder if needed and set it to PATH
IF NOT "!output_on_screen!"=="False" (
    @echo Checking wheter ^'!install_location!^\^' exists already>CON
)
@echo Checking wheter ^'!install_location!^\^' exists already
call ^"!running_directory!inPath^" ^"install_location^" && (IF NOT "!output_on_screen!"=="False" ( @echo 	!install_location! is already in PATH>CON) && @echo 	!install_location! is already in PATH) || (call ^"!running_directory!addPath^" ^"install_location^" & setx>nul PATH "%PATH%;!install_location!" /m & IF NOT "!output_on_screen!"=="False" ( @echo 	!install_location! set to PATH>CON) && @echo 	!install_location! set to PATH)
if not exist "!install_location!\" (
    mkdir ^"!install_location!^"
)
@echo Checking wheter ^'!running_location!^\^' exists already
if not exist "!running_location!\" (
    mkdir ^"!running_location!^"
)
if not exist "!running_location!\.rdp\" (
    mkdir ^"!running_location!\.rdp^"
)
rem Copy the files to the folder
IF NOT "!output_on_screen!"=="False" (
    @echo Copying files to ^'!install_location!^'>CON
)
@echo Copying files to ^'!install_location!^'
    xcopy "!running_directory!cloud.py" "!install_location!\" /y
    xcopy "!running_directory!cloud_connect_from_windows.py" "!install_location!\" /y
    xcopy "!running_directory!win_install.py" "!install_location!\" /y
    xcopy "!running_directory!windowsclasses.py" "!install_location!\" /y
    xcopy "!running_directory!OrderedDict.py" "!install_location!\" /y
    xcopy "!running_directory!putty.exe" "!install_location!\" /y
IF NOT "!output_on_screen!"=="False" (
    @echo 	Done>CON
    @echo.>CON
)
@echo 	Done
@echo.
IF NOT "!output_on_screen!"=="False" (
    @echo Starting the python installation script>CON
)
@echo Starting the python installation script
call python ^"!running_directory!win_install.py^"!nx_install! ^-l "!install_location!\\"!website!
IF NOT "!output_on_screen!"=="False" (
    @echo 	Done>CON
    @echo Installation complete>CON
)
@echo 	Done
@echo Installation complete
GOTO END


:LCase
:UCase
:: Converts to upper/lower case variable contents
:: Syntax: CALL :UCase _VAR1 _VAR2
:: Syntax: CALL :LCase _VAR1 _VAR2
:: _VAR1 = Variable NAME whose VALUE is to be converted to upper/lower case
:: _VAR2 = NAME of variable to hold the converted value
:: Note: Use variable NAMES in the CALL, not values (pass "by reference")

SET _UCase=A B C D E F G H I J K L M N O P Q R S T U V W X Y Z
SET _LCase=a b c d e f g h i j k l m n o p q r s t u v w x y z
SET _Lib_UCase_Tmp=!%1!
IF /I "%0"==":UCase" SET _Abet=%_UCase%
IF /I "%0"==":LCase" SET _Abet=%_LCase%
FOR %%Z IN (%_Abet%) DO SET _Lib_UCase_Tmp=!_Lib_UCase_Tmp:%%Z=%%Z!
SET %2=%_Lib_UCase_Tmp%
GOTO END

rem Subroutine to get the exact path out from a file location, but strip the file name
:Split
SET %2=%~dp1
GOTO END

:END