#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Configuration of the Windows specific tools to enhance the ease of use
of the CIRCLE cloud. Handles the auto launch and auto configuration
of these specific connectivity programs.
"""

import binascii
import glob
import locale
import logging
import os
import subprocess
import time
import tempfile

import win32crypt

def connect(vm):
    """
    Handles to connection to the Virtual Machines from the local
    machine

    Keyword arguments:
    vm.protocol -- SSH and RDP possible
    vm.host     -- Address of the Virtual Computer
    vm.port     -- The port where we can access the Virtual Computer
    vm.user     -- Username used for the connection
    vm.password -- Password used for the connection
    """
    logger = logging.getLogger()
    logger.debug('Connect methods started')
    if vm.protocol == "SSH":
        logger.info('SSH protocol received')
        arguments = str("-ssh -P %(port)s -pw %(password)s"
                        " %(user)s@%(host)s" % {
                            'port': vm.port,
                            'password': vm.password,
                            'user': vm.user,
                            'host': vm.host})
        directory = os.path.dirname(os.path.abspath(__file__))
        logger.info('Popen: "%s\\putty.exe"', directory)
        logger.debug('Determined arguments: %s', arguments)
        subprocess.Popen('"%(path)s\\putty.exe" %(arguments)s' % {
            'path': directory,
            'arguments': arguments}, shell=True)
    elif vm.protocol == "RDP":
        logger.debug('RDP protocol received')
        full_address = "full address:s:%s:%s" % (vm.host, vm.port)
        user = "username:s:%s" % vm.user
        config_file = "%s%s" % (
            tempfile.gettempdir(),
            "\\circle_" + vm.user + str(int(time.time() * 1000)) + ".rdp")
        logger.info('Creating config file %s' % config_file)
        password = win32crypt.CryptProtectData(vm.password.encode('utf-16-le'), 'psw', None, None, None, 0).hex()
        config = RPD_template.format(vm.user, vm.host, vm.port, password)
        f = open(config_file, 'w')
        f.write(config)
        f.close()
        logger.debug('Popen the config file: %s', config_file)
        subprocess.Popen([config_file], shell=True).wait()
        os.remove(config_file)
    logger.info('Client finished working')

RPD_template = """username:s:{}
full address:s:{}:{}
authentication level:i:0
password 51:b:{}"""
