#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Pywin32 installer for CIRCLE client application
"""

import os
import sys
import subprocess
import windowsclasses


def main():
    """
    Main program

    Job:
    Install Pywin32 to the computer
    """
    if sys.hexversion < 0x02060000:
        print "Not a 2.6+ version Python is running, commencing update"
        subprocess.Popen(
            "%s\\no_root_install.bat" % os.path.dirname(
                os.path.realpath(__file__)))
        sys.exit(1)
    else:
        pywin32_version = str(219)
        if sys.hexversion < 0x02070000:
            if windowsclasses.DecideArchitecture.Is64Windows():
                subprocess.Popen(
                    "%s\\x64\\pywin32-%s.win-amd64-py2.6.exe" % (
                        os.path.dirname(os.path.realpath(__file__)),
                        pywin32_version)).wait()
            else:
                subprocess.Popen(
                    "%s\\x86\\pywin32-%s.win32-py2.6.exe" % (
                        os.path.dirname(os.path.realpath(__file__)),
                        pywin32_version)).wait()
        elif sys.hexversion < 0x02080000:
            if windowsclasses.DecideArchitecture.Is64Windows():
                subprocess.Popen(
                    "%s\\x64\\pywin32-%s.win-amd64-py2.7.exe" % (
                        os.path.dirname(os.path.realpath(__file__)),
                        pywin32_version)).wait()
            else:
                subprocess.Popen(
                    "%s\\x86\\pywin32-%s.win32-py2.7.exe" % (
                        os.path.dirname(os.path.realpath(__file__)),
                        pywin32_version)).wait()
        else:
            print "Unsupported Python version is found!"


if __name__ == "__main__":
    main()
