/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ConfirmHandler;
import com.gargoylesoftware.htmlunit.DialogWindow;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PromptHandler;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.StatusHandler;
import com.gargoylesoftware.htmlunit.StorageHolder;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowNotFoundException;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.MSXMLActiveXObjectFactory;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMDocument;
import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptFunctionJob;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.CanSetReadOnly;
import com.gargoylesoftware.htmlunit.javascript.configuration.CanSetReadOnlyStatus;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.ApplicationCache;
import com.gargoylesoftware.htmlunit.javascript.host.ClipboardData;
import com.gargoylesoftware.htmlunit.javascript.host.Console;
import com.gargoylesoftware.htmlunit.javascript.host.Document;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.EventListenersContainer;
import com.gargoylesoftware.htmlunit.javascript.host.External;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLCollectionFrames;
import com.gargoylesoftware.htmlunit.javascript.host.History;
import com.gargoylesoftware.htmlunit.javascript.host.Location;
import com.gargoylesoftware.htmlunit.javascript.host.MessageEvent;
import com.gargoylesoftware.htmlunit.javascript.host.Navigator;
import com.gargoylesoftware.htmlunit.javascript.host.Netscape;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.Popup;
import com.gargoylesoftware.htmlunit.javascript.host.Screen;
import com.gargoylesoftware.htmlunit.javascript.host.Selection;
import com.gargoylesoftware.htmlunit.javascript.host.Storage;
import com.gargoylesoftware.htmlunit.javascript.host.StorageList;
import com.gargoylesoftware.htmlunit.javascript.host.WindowProxy;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleSheetList;
import com.gargoylesoftware.htmlunit.javascript.host.html.DocumentProxy;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLUnknownElement;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLDocument;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsxClass
public class Window
extends SimpleScriptable
implements ScriptableWithFallbackGetter,
Function {
    private static final Log LOG = LogFactory.getLog(Window.class);
    private static final int MIN_TIMER_DELAY = 1;
    private Document document_;
    private DocumentProxy documentProxy_;
    private Navigator navigator_;
    private WebWindow webWindow_;
    private WindowProxy windowProxy_;
    private Screen screen_;
    private History history_;
    private Location location_;
    private ScriptableObject console_;
    private ApplicationCache applicationCache_;
    private Selection selection_;
    private Event currentEvent_;
    private String status_ = "";
    private HTMLCollection frames_;
    private Map<Class<? extends SimpleScriptable>, Scriptable> prototypes_ = new HashMap<Class<? extends SimpleScriptable>, Scriptable>();
    private EventListenersContainer eventListenersContainer_;
    private Object controllers_;
    private Object opener_;
    private Object top_ = NOT_FOUND;
    private transient WeakHashMap<Node, ComputedCSSStyleDeclaration> computedStyles_ = new WeakHashMap();
    private final Map<StorageHolder.Type, Storage> storages_ = new HashMap<StorageHolder.Type, Storage>();
    private StorageList storageList_;
    private static final Set<String> ATTRIBUTES_AFFECTING_PARENT = new HashSet<String>(Arrays.asList("style", "class", "height", "width"));

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.computedStyles_ = new WeakHashMap();
    }

    @Override
    public Scriptable getPrototype(Class<? extends SimpleScriptable> jsClass) {
        return this.prototypes_.get(jsClass);
    }

    public void setPrototypes(Map<Class<? extends SimpleScriptable>, Scriptable> map) {
        this.prototypes_ = map;
    }

    @JsxFunction
    public void alert(Object message) {
        String stringMessage = Context.toString(message);
        AlertHandler handler = this.getWebWindow().getWebClient().getAlertHandler();
        if (handler == null) {
            LOG.warn("window.alert(\"" + stringMessage + "\") no alert handler installed");
        } else {
            handler.handleAlert(((HTMLDocument)this.document_).getHtmlPage(), stringMessage);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public String btoa(String stringToEncode) {
        return new String(Base64.encodeBase64(stringToEncode.getBytes()));
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public String atob(String encodedData) {
        return new String(Base64.decodeBase64(encodedData.getBytes()));
    }

    @JsxFunction
    public boolean confirm(String message) {
        ConfirmHandler handler = this.getWebWindow().getWebClient().getConfirmHandler();
        if (handler == null) {
            LOG.warn("window.confirm(\"" + message + "\") no confirm handler installed, simulating the OK button");
            return true;
        }
        return handler.handleConfirm(((HTMLDocument)this.document_).getHtmlPage(), message);
    }

    @JsxFunction
    public String prompt(String message) {
        PromptHandler handler = this.getWebWindow().getWebClient().getPromptHandler();
        if (handler == null) {
            LOG.warn("window.prompt(\"" + message + "\") no prompt handler installed");
            return null;
        }
        return handler.handlePrompt(((HTMLDocument)this.document_).getHtmlPage(), message);
    }

    @JsxGetter(propertyName="document")
    public DocumentProxy getDocument_js() {
        return this.documentProxy_;
    }

    public Document getDocument() {
        return this.document_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public ApplicationCache getApplicationCache() {
        return this.applicationCache_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public Object getEvent() {
        return this.currentEvent_;
    }

    public Event getCurrentEvent() {
        return this.currentEvent_;
    }

    void setCurrentEvent(Event event) {
        this.currentEvent_ = event;
    }

    @JsxFunction
    public WindowProxy open(Object url, Object name, Object features, Object replace) {
        WebClient webClient;
        String urlString = null;
        if (url != Undefined.instance) {
            urlString = Context.toString(url);
        }
        String windowName = "";
        if (name != Undefined.instance) {
            windowName = Context.toString(name);
        }
        String featuresString = null;
        if (features != Undefined.instance) {
            featuresString = Context.toString(features);
        }
        if ((webClient = this.getWebWindow().getWebClient()).getOptions().isPopupBlockerEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring window.open() invocation because popups are blocked.");
            }
            return null;
        }
        boolean replaceCurrentEntryInBrowsingHistory = false;
        if (replace != Undefined.instance) {
            replaceCurrentEntryInBrowsingHistory = Context.toBoolean(replace);
        }
        if ((featuresString != null || replaceCurrentEntryInBrowsingHistory) && LOG.isDebugEnabled()) {
            LOG.debug("window.open: features and replaceCurrentEntryInBrowsingHistory not implemented: url=[" + urlString + "] windowName=[" + windowName + "] features=[" + featuresString + "] replaceCurrentEntry=[" + replaceCurrentEntryInBrowsingHistory + "]");
        }
        if (StringUtils.isEmpty(urlString) && !"".equals(windowName)) {
            try {
                WebWindow webWindow = webClient.getWebWindowByName(windowName);
                return Window.getProxy(webWindow);
            }
            catch (WebWindowNotFoundException e) {
                // empty catch block
            }
        }
        URL newUrl = this.makeUrlForOpenWindow(urlString);
        WebWindow newWebWindow = webClient.openWindow(newUrl, windowName, this.webWindow_);
        return Window.getProxy(newWebWindow);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE, maxVersion=10.0f)})
    public Popup createPopup() {
        Popup popup = new Popup();
        popup.setParentScope(this);
        popup.setPrototype(this.getPrototype(Popup.class));
        popup.init(this);
        return popup;
    }

    private URL makeUrlForOpenWindow(String urlString) {
        if (urlString.isEmpty()) {
            return WebClient.URL_ABOUT_BLANK;
        }
        try {
            Page page = this.getWebWindow().getEnclosedPage();
            if (page != null && page.isHtmlPage()) {
                return ((HtmlPage)page).getFullyQualifiedUrl(urlString);
            }
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            LOG.error("Unable to create URL for openWindow: relativeUrl=[" + urlString + "]", e);
            return null;
        }
    }

    @JsxFunction
    public int setTimeout(Object code, int timeout, Object language) {
        int id;
        if (timeout < 1) {
            timeout = 1;
        }
        if (code == null) {
            throw Context.reportRuntimeError("Function not provided.");
        }
        WebWindow webWindow = this.getWebWindow();
        Page page = (Page)this.getDomNodeOrNull();
        if (code instanceof String) {
            String s = (String)code;
            String description = "window.setTimeout(" + s + ", " + timeout + ")";
            JavaScriptJob job = BackgroundJavaScriptFactory.theFactory().createJavaScriptJob(timeout, null, description, webWindow, s);
            id = webWindow.getJobManager().addJob(job, page);
        } else if (code instanceof Function) {
            Function f = (Function)code;
            String functionName = f instanceof FunctionObject ? ((FunctionObject)f).getFunctionName() : String.valueOf(f);
            String description = "window.setTimeout(" + functionName + ", " + timeout + ")";
            JavaScriptFunctionJob job = BackgroundJavaScriptFactory.theFactory().createJavaScriptJob(timeout, null, description, webWindow, f);
            id = webWindow.getJobManager().addJob(job, page);
        } else {
            throw Context.reportRuntimeError("Unknown type for function.");
        }
        return id;
    }

    @JsxFunction
    public void clearTimeout(int timeoutId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("clearTimeout(" + timeoutId + ")");
        }
        this.getWebWindow().getJobManager().removeJob(timeoutId);
    }

    @JsxGetter
    public Navigator getNavigator() {
        return this.navigator_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public Navigator getClientInformation() {
        return this.navigator_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public ClipboardData getClipboardData() {
        ClipboardData clipboardData = new ClipboardData();
        clipboardData.setParentScope(this);
        clipboardData.setPrototype(this.getPrototype(clipboardData.getClass()));
        return clipboardData;
    }

    @JsxGetter(propertyName="window")
    public WindowProxy getWindow_js() {
        return this.windowProxy_;
    }

    @JsxGetter
    public WindowProxy getSelf() {
        return this.windowProxy_;
    }

    @JsxGetter
    public Storage getLocalStorage() {
        return this.getStorage(StorageHolder.Type.LOCAL_STORAGE);
    }

    @JsxGetter
    public Storage getSessionStorage() {
        return this.getStorage(StorageHolder.Type.SESSION_STORAGE);
    }

    public Storage getStorage(StorageHolder.Type storageType) {
        Storage storage = this.storages_.get((Object)storageType);
        if (storage == null) {
            WebWindow webWindow = this.getWebWindow();
            Map<String, String> store = webWindow.getWebClient().getStorageHolder().getStore(storageType, webWindow.getEnclosedPage());
            storage = new Storage(this, store);
            this.storages_.put(storageType, storage);
        }
        return storage;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF, maxVersion=10.0f)})
    public StorageList getGlobalStorage() {
        if (this.storageList_ == null) {
            this.storageList_ = new StorageList();
            this.storageList_.setParentScope(this);
            this.storageList_.setPrototype(this.getPrototype(StorageList.class));
        }
        return this.storageList_;
    }

    @JsxGetter
    public Location getLocation() {
        return this.location_;
    }

    @JsxSetter
    public void setLocation(String newLocation) throws IOException {
        this.location_.setHref(newLocation);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF, minVersion=4.0f), @WebBrowser(value=BrowserName.IE, minVersion=9.0f), @WebBrowser(value=BrowserName.CHROME)})
    public ScriptableObject getConsole() {
        return this.console_;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF, minVersion=4.0f), @WebBrowser(value=BrowserName.IE, minVersion=9.0f), @WebBrowser(value=BrowserName.CHROME)})
    public void setConsole(ScriptableObject console) {
        this.console_ = console;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void dump(String message) {
        if (this.console_ instanceof Console) {
            Console.log(null, this.console_, new Object[]{message}, null);
        }
    }

    @JsxGetter
    public Screen getScreen() {
        return this.screen_;
    }

    @JsxGetter
    public History getHistory() {
        return this.history_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public External getExternal() {
        External external = new External();
        external.setParentScope(this);
        external.setPrototype(this.getPrototype(external.getClass()));
        return external;
    }

    public void initialize(WebWindow webWindow) {
        WebWindow opener;
        this.webWindow_ = webWindow;
        this.webWindow_.setScriptObject(this);
        this.windowProxy_ = new WindowProxy(this.webWindow_);
        Page enclosedPage = webWindow.getEnclosedPage();
        this.document_ = enclosedPage instanceof XmlPage ? new XMLDocument() : new HTMLDocument();
        this.document_.setParentScope(this);
        this.document_.setPrototype(this.getPrototype(this.document_.getClass()));
        this.document_.setWindow(this);
        if (enclosedPage instanceof SgmlPage) {
            SgmlPage page = (SgmlPage)enclosedPage;
            this.document_.setDomNode(page);
            DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl();
            page.addDomChangeListener(listener);
            if (page.isHtmlPage()) {
                ((HtmlPage)page).addHtmlAttributeChangeListener(listener);
            }
        }
        this.documentProxy_ = new DocumentProxy(this.webWindow_);
        this.navigator_ = new Navigator();
        this.navigator_.setParentScope(this);
        this.navigator_.setPrototype(this.getPrototype(this.navigator_.getClass()));
        this.screen_ = new Screen();
        this.screen_.setParentScope(this);
        this.screen_.setPrototype(this.getPrototype(this.screen_.getClass()));
        this.history_ = new History();
        this.history_.setParentScope(this);
        this.history_.setPrototype(this.getPrototype(this.history_.getClass()));
        this.location_ = new Location();
        this.location_.setParentScope(this);
        this.location_.setPrototype(this.getPrototype(this.location_.getClass()));
        this.location_.initialize(this);
        this.console_ = new Console();
        ((Console)this.console_).setWebWindow(this.webWindow_);
        this.console_.setParentScope(this);
        ((Console)this.console_).setPrototype(this.getPrototype(((SimpleScriptable)this.console_).getClass()));
        this.applicationCache_ = new ApplicationCache();
        this.applicationCache_.setParentScope(this);
        this.applicationCache_.setPrototype(this.getPrototype(this.applicationCache_.getClass()));
        Context ctx = Context.getCurrentContext();
        this.controllers_ = ctx.newObject(this);
        if (this.webWindow_ instanceof TopLevelWindow && (opener = ((TopLevelWindow)this.webWindow_).getOpener()) != null) {
            this.opener_ = opener.getScriptObject();
        }
    }

    public void initialize(Page enclosedPage) {
        if (enclosedPage != null && enclosedPage.isHtmlPage()) {
            HtmlPage htmlPage = (HtmlPage)enclosedPage;
            this.setDomNode(htmlPage);
            this.eventListenersContainer_ = null;
            WebAssert.notNull("document_", this.document_);
            this.document_.setDomNode(htmlPage);
        }
    }

    public void initialize() {
    }

    @JsxGetter
    public Object getTop() {
        if (this.top_ != NOT_FOUND) {
            return this.top_;
        }
        WebWindow top = this.getWebWindow().getTopWindow();
        return Window.getProxy(top);
    }

    @JsxSetter
    public void setTop(Object o) {
        this.top_ = o;
    }

    @JsxGetter
    public WindowProxy getParent() {
        WebWindow parent = this.getWebWindow().getParentWindow();
        return Window.getProxy(parent);
    }

    @JsxGetter
    public Object getOpener() {
        Object opener = this.opener_;
        if (opener instanceof Window) {
            opener = ((Window)opener).windowProxy_;
        }
        return opener;
    }

    @JsxSetter
    public void setOpener(Object newValue) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_CHANGE_OPENER_NOT_ALLOWED) && newValue != this.opener_) {
            if (this.opener_ == null || newValue == null || newValue == Context.getUndefinedValue()) {
                newValue = null;
            } else {
                throw Context.reportRuntimeError("Can't set opener!");
            }
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_CHANGE_OPENER_ONLY_WINDOW_OBJECT) && newValue != null && newValue != Context.getUndefinedValue() && !(newValue instanceof Window)) {
            throw Context.reportRuntimeError("Can't set opener to something other than a window!");
        }
        this.opener_ = newValue;
    }

    @JsxGetter
    public Object getFrameElement() {
        WebWindow window = this.getWebWindow();
        if (window instanceof FrameWindow) {
            return ((FrameWindow)window).getFrameElement().getScriptObject();
        }
        return null;
    }

    @JsxGetter(propertyName="frames")
    public WindowProxy getFrames_js() {
        return this.windowProxy_;
    }

    @JsxGetter
    public int getLength() {
        return this.getFrames().getLength();
    }

    private HTMLCollection getFrames() {
        if (this.frames_ == null) {
            HtmlPage page = (HtmlPage)this.getWebWindow().getEnclosedPage();
            this.frames_ = new HTMLCollectionFrames(page);
        }
        return this.frames_;
    }

    public WebWindow getWebWindow() {
        return this.webWindow_;
    }

    @JsxFunction
    public void focus() {
        WebWindow window = this.getWebWindow();
        window.getWebClient().setCurrentWindow(window);
    }

    @JsxFunction
    public void blur() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("window.blur() not implemented");
        }
    }

    @JsxFunction
    public void close() {
        WebWindow webWindow = this.getWebWindow();
        if (webWindow instanceof TopLevelWindow) {
            ((TopLevelWindow)webWindow).close();
        } else {
            webWindow.getWebClient().deregisterWebWindow(webWindow);
        }
    }

    @JsxGetter
    @CanSetReadOnly(value=CanSetReadOnlyStatus.IGNORE)
    public boolean getClosed() {
        WebWindow webWindow = this.getWebWindow();
        return !webWindow.getWebClient().containsWebWindow(webWindow);
    }

    @JsxFunction
    public void moveTo(int x, int y) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("window.moveTo() not implemented");
        }
    }

    @JsxFunction
    public void moveBy(int x, int y) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("window.moveBy() not implemented");
        }
    }

    @JsxFunction
    public void resizeBy(int width, int height) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("window.resizeBy() not implemented");
        }
    }

    @JsxFunction
    public void resizeTo(int width, int height) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("window.resizeTo() not implemented");
        }
    }

    @JsxFunction
    public void scroll(int x, int y) {
        this.scrollTo(x, y);
    }

    @JsxFunction
    public void scrollBy(int x, int y) {
        HTMLElement body = ((HTMLDocument)this.document_).getBody();
        if (body != null) {
            body.setScrollLeft(body.getScrollLeft() + x);
            body.setScrollTop(body.getScrollTop() + y);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public void scrollByLines(int lines) {
        HTMLElement body = ((HTMLDocument)this.document_).getBody();
        if (body != null) {
            body.setScrollTop(body.getScrollTop() + 19 * lines);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public void scrollByPages(int pages) {
        HTMLElement body = ((HTMLDocument)this.document_).getBody();
        if (body != null) {
            body.setScrollTop(body.getScrollTop() + this.getInnerHeight() * pages);
        }
    }

    @JsxFunction
    public void scrollTo(int x, int y) {
        HTMLElement body = ((HTMLDocument)this.document_).getBody();
        if (body != null) {
            body.setScrollLeft(x);
            body.setScrollTop(y);
        }
    }

    @JsxSetter
    public void setOnload(Object newOnload) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONLOAD_UNDEFINED_THROWS_ERROR) && Context.getUndefinedValue().equals(newOnload)) {
            throw Context.reportRuntimeError("Invalid onload value: undefined.");
        }
        this.getEventListenersContainer().setEventHandlerProp("load", newOnload);
    }

    @JsxSetter
    public void setOnclick(Object newOnload) {
        this.getEventListenersContainer().setEventHandlerProp("click", newOnload);
    }

    @JsxGetter
    public Object getOnclick() {
        return this.getEventListenersContainer().getEventHandlerProp("click");
    }

    @JsxSetter
    public void setOndblclick(Object newHandler) {
        this.getEventListenersContainer().setEventHandlerProp("dblclick", newHandler);
    }

    @JsxGetter
    public Object getOndblclick() {
        return this.getEventListenersContainer().getEventHandlerProp("dblclick");
    }

    @JsxGetter
    public Object getOnload() {
        Object onload = this.getEventListenersContainer().getEventHandlerProp("load");
        if (onload == null) {
            HtmlPage page = (HtmlPage)this.getWebWindow().getEnclosedPage();
            HtmlElement body = page.getBody();
            if (body != null) {
                HTMLBodyElement b = (HTMLBodyElement)body.getScriptObject();
                return b.getEventHandler("onload");
            }
            return null;
        }
        return onload;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public Object getOnhashchange() {
        return this.getEventListenersContainer().getEventHandlerProp("hashchange");
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public void setOnhashchange(Object newHandler) {
        this.getEventListenersContainer().setEventHandlerProp("hashchange", newHandler);
    }

    public EventListenersContainer getEventListenersContainer() {
        if (this.eventListenersContainer_ == null) {
            this.eventListenersContainer_ = new EventListenersContainer(this);
        }
        return this.eventListenersContainer_;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE, maxVersion=9.0f)})
    public boolean attachEvent(String type, Function listener) {
        return this.getEventListenersContainer().addEventListener(StringUtils.substring(type, 2), listener, false);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=9.0f)})
    public void addEventListener(String type, Function listener, boolean useCapture) {
        this.getEventListenersContainer().addEventListener(type, listener, useCapture);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE, maxVersion=9.0f)})
    public void detachEvent(String type, Function listener) {
        this.getEventListenersContainer().removeEventListener(StringUtils.substring(type, 2), listener, false);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=9.0f)})
    public void removeEventListener(String type, Function listener, boolean useCapture) {
        this.getEventListenersContainer().removeEventListener(type, listener, useCapture);
    }

    @JsxGetter
    public String getName() {
        return this.getWebWindow().getName();
    }

    @JsxSetter
    public void setName(String name) {
        this.getWebWindow().setName(name);
    }

    @JsxGetter
    public Object getOnbeforeunload() {
        return this.getHandlerForJavaScript("beforeunload");
    }

    @JsxSetter
    public void setOnbeforeunload(Object onbeforeunload) {
        this.setHandlerForJavaScript("beforeunload", onbeforeunload);
    }

    @JsxGetter
    public Object getOnerror() {
        return this.getHandlerForJavaScript("error");
    }

    @JsxSetter
    public void setOnerror(Object onerror) {
        this.setHandlerForJavaScript("error", onerror);
    }

    public void triggerOnError(ScriptException e) {
        Object o = this.getOnerror();
        if (o instanceof Function) {
            Object[] args;
            Function f = (Function)o;
            String msg = e.getMessage();
            String url = e.getPage().getUrl().toExternalForm();
            int line = e.getFailingLineNumber();
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_ONERROR_COLUMN_ARGUMENT)) {
                int column = e.getFailingColumnNumber();
                args = new Object[]{msg, url, line, column};
            } else {
                args = new Object[]{msg, url, line};
            }
            f.call(Context.getCurrentContext(), this, this, args);
        }
    }

    private Object getHandlerForJavaScript(String eventName) {
        return this.getEventListenersContainer().getEventHandlerProp(eventName);
    }

    private void setHandlerForJavaScript(String eventName, Object handler) {
        if (handler == null || handler instanceof Function) {
            this.getEventListenersContainer().setEventHandlerProp(eventName, handler);
        }
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_IS_A_FUNCTION)) {
            throw Context.reportRuntimeError("Window is not a function.");
        }
        if (args.length > 0) {
            Object arg = args[0];
            if (arg instanceof String) {
                return ScriptableObject.getProperty((Scriptable)this, (String)arg);
            }
            if (arg instanceof Number) {
                return ScriptableObject.getProperty((Scriptable)this, ((Number)arg).intValue());
            }
        }
        return Context.getUndefinedValue();
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_IS_A_FUNCTION)) {
            throw Context.reportRuntimeError("Window is not a function.");
        }
        return null;
    }

    @Override
    public Object getWithFallback(String name) {
        Object result = NOT_FOUND;
        Object domNode = this.getDomNodeOrNull();
        if (domNode != null) {
            HtmlElement unknownElement;
            HtmlPage page = (HtmlPage)((DomNode)domNode).getPage();
            result = Window.getFrameWindowByName(page, name);
            if (result == NOT_FOUND) {
                List<DomElement> elements = page.getElementsByName(name);
                if (elements.size() == 1) {
                    result = this.getScriptableFor(elements.get(0));
                } else if (elements.size() > 1) {
                    result = ((HTMLDocument)this.document_).getElementsByName(name);
                } else {
                    try {
                        Object htmlElement = page.getHtmlElementById(name);
                        result = this.getScriptableFor(htmlElement);
                    }
                    catch (ElementNotFoundException e) {
                        result = NOT_FOUND;
                    }
                }
            }
            if (result instanceof Window) {
                WebWindow webWindow = ((Window)result).getWebWindow();
                result = Window.getProxy(webWindow);
            } else if (result instanceof HTMLUnknownElement && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XML_IN_HTML_VIA_ACTIVEXOBJECT) && "xml".equals((unknownElement = ((HTMLUnknownElement)result).getDomNodeOrDie()).getNodeName())) {
                MSXMLActiveXObjectFactory factory = this.getWebWindow().getWebClient().getMSXMLActiveXObjectFactory();
                XMLDOMDocument document = (XMLDOMDocument)factory.create("Microsoft.XMLDOM", this.getWebWindow());
                Iterator<HtmlElement> children = unknownElement.getHtmlElementDescendants().iterator();
                if (children.hasNext()) {
                    HtmlElement root = children.next();
                    document.loadXML(root.asXml().trim());
                }
                result = document;
            }
        }
        return result;
    }

    @Override
    public Object get(int index, Scriptable start) {
        HTMLCollection frames = this.getFrames();
        if (index >= frames.getLength()) {
            return Context.getUndefinedValue();
        }
        return frames.item((Object)index);
    }

    @Override
    public Object get(String name, Scriptable start) {
        if ("Option".equals(name)) {
            name = "HTMLOptionElement";
        } else if ("Image".equals(name)) {
            name = "HTMLImageElement";
        }
        return super.get(name, start);
    }

    private static Object getFrameWindowByName(HtmlPage page, String name) {
        try {
            return page.getFrameByName(name).getScriptObject();
        }
        catch (ElementNotFoundException e) {
            return NOT_FOUND;
        }
    }

    public static WindowProxy getProxy(WebWindow w) {
        return ((Window)w.getScriptObject()).windowProxy_;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE, maxVersion=9.0f)})
    public void execScript(String script, Object language) {
        String languageStr = Context.toString(language);
        if (language != Undefined.instance && !"javascript".equalsIgnoreCase(languageStr) && !"jscript".equalsIgnoreCase(languageStr)) {
            if ("vbscript".equalsIgnoreCase(languageStr)) {
                throw Context.reportRuntimeError("VBScript not supported in Window.execScript().");
            }
            throw Context.reportRuntimeError("Invalid class string");
        }
        ScriptRuntime.evalSpecial(Context.getCurrentContext(), this, this, new Object[]{script}, null, 0);
    }

    @JsxGetter
    public String getStatus() {
        return this.status_;
    }

    @JsxSetter
    public void setStatus(String message) {
        this.status_ = message;
        StatusHandler statusHandler = this.webWindow_.getWebClient().getStatusHandler();
        if (statusHandler != null) {
            statusHandler.statusMessageChanged(this.webWindow_.getEnclosedPage(), message);
        }
    }

    @JsxFunction
    public int setInterval(Object code, int timeout, Object language) {
        int id;
        if (timeout == 0 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_133)) {
            return this.setTimeout(code, timeout, language);
        }
        if (timeout < 1) {
            timeout = 1;
        }
        WebWindow w = this.getWebWindow();
        Page page = (Page)this.getDomNodeOrNull();
        String description = "window.setInterval(" + timeout + ")";
        if (code == null) {
            throw Context.reportRuntimeError("Function not provided.");
        }
        if (code instanceof String) {
            String s = (String)code;
            JavaScriptJob job = BackgroundJavaScriptFactory.theFactory().createJavaScriptJob(timeout, (Integer)timeout, description, w, s);
            id = this.getWebWindow().getJobManager().addJob(job, page);
        } else if (code instanceof Function) {
            Function f = (Function)code;
            JavaScriptFunctionJob job = BackgroundJavaScriptFactory.theFactory().createJavaScriptJob(timeout, (Integer)timeout, description, w, f);
            id = this.getWebWindow().getJobManager().addJob(job, page);
        } else {
            throw Context.reportRuntimeError("Unknown type for function.");
        }
        return id;
    }

    @JsxFunction
    public void clearInterval(int intervalID) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("clearInterval(" + intervalID + ")");
        }
        this.getWebWindow().getJobManager().removeJob(intervalID);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public int getInnerWidth() {
        return this.getWebWindow().getInnerWidth();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public int getOuterWidth() {
        return this.getWebWindow().getOuterWidth();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public int getInnerHeight() {
        return this.getWebWindow().getInnerHeight();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public int getOuterHeight() {
        return this.getWebWindow().getOuterHeight();
    }

    @JsxFunction
    public void print() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("window.print() not implemented");
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void captureEvents(String type) {
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void CollectGarbage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=9.0f), @WebBrowser(value=BrowserName.CHROME)})
    public ComputedCSSStyleDeclaration getComputedStyle(Element element, String pseudo) {
        ComputedCSSStyleDeclaration style;
        WeakHashMap<Node, ComputedCSSStyleDeclaration> weakHashMap = this.computedStyles_;
        synchronized (weakHashMap) {
            style = this.computedStyles_.get(element);
        }
        if (style != null) {
            return style;
        }
        CSSStyleDeclaration original = element.getStyle();
        style = new ComputedCSSStyleDeclaration(original);
        StyleSheetList sheets = ((HTMLDocument)this.document_).getStyleSheets();
        boolean trace = LOG.isTraceEnabled();
        for (int i = 0; i < sheets.getLength(); ++i) {
            CSSStyleSheet sheet = (CSSStyleSheet)sheets.item(i);
            if (!sheet.isActive()) continue;
            if (trace) {
                LOG.trace("modifyIfNecessary: " + sheet + ", " + style + ", " + element);
            }
            sheet.modifyIfNecessary(style, element);
        }
        WeakHashMap<Node, ComputedCSSStyleDeclaration> weakHashMap2 = this.computedStyles_;
        synchronized (weakHashMap2) {
            this.computedStyles_.put(element, style);
        }
        return style;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public Selection getSelection() {
        FrameWindow frameWindow;
        WebWindow webWindow = this.getWebWindow();
        if (webWindow instanceof FrameWindow && !(frameWindow = (FrameWindow)webWindow).getFrameElement().isDisplayed()) {
            return null;
        }
        return this.getSelectionImpl();
    }

    public Selection getSelectionImpl() {
        if (this.selection_ == null) {
            this.selection_ = new Selection();
            this.selection_.setParentScope(this);
            this.selection_.setPrototype(this.getPrototype(this.selection_.getClass()));
        }
        return this.selection_;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF)})
    public Object showModalDialog(String url, Object arguments, String features) {
        WebWindow webWindow = this.getWebWindow();
        WebClient client = webWindow.getWebClient();
        try {
            URL completeUrl = ((HtmlPage)this.getDomNodeOrDie()).getFullyQualifiedUrl(url);
            DialogWindow dialog = client.openDialogWindow(completeUrl, webWindow, arguments);
            ScriptableObject jsDialog = (ScriptableObject)dialog.getScriptObject();
            return jsDialog.get("returnValue", (Scriptable)jsDialog);
        }
        catch (IOException e) {
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public Object showModelessDialog(String url, Object arguments, String features) {
        WebWindow webWindow = this.getWebWindow();
        WebClient client = webWindow.getWebClient();
        try {
            URL completeUrl = ((HtmlPage)this.getDomNodeOrDie()).getFullyQualifiedUrl(url);
            DialogWindow dialog = client.openDialogWindow(completeUrl, webWindow, arguments);
            Window jsDialog = (Window)dialog.getScriptObject();
            return jsDialog;
        }
        catch (IOException e) {
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public Object getControllers() {
        return this.controllers_;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setControllers(Object value) {
        this.controllers_ = value;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public int getMozInnerScreenX() {
        return 8;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public int getMozInnerScreenY() {
        return 91;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public int getMozPaintCount() {
        return 0;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public String ScriptEngine() {
        return "JScript";
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public int ScriptEngineBuildVersion() {
        return 12345;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public int ScriptEngineMajorVersion() {
        if (this.getBrowserVersion().getBrowserVersionNumeric() < 10.0f) {
            return 5;
        }
        return (int)this.getBrowserVersion().getBrowserVersionNumeric();
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public int ScriptEngineMinorVersion() {
        if (this.getBrowserVersion().getBrowserVersionNumeric() < 10.0f) {
            return (int)this.getBrowserVersion().getBrowserVersionNumeric();
        }
        return 0;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public void stop() {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public int getPageXOffset() {
        return 0;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public int getPageYOffset() {
        return 0;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public int getScrollX() {
        return 0;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public int getScrollY() {
        return 0;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public Netscape getNetscape() {
        return new Netscape(this);
    }

    public ScriptResult executeEvent(Event event) {
        return this.executeEvent(event, this.eventListenersContainer_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScriptResult executeEvent(Event event, EventListenersContainer eventListenersContainer) {
        if (eventListenersContainer != null) {
            boolean eventParam = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_EVENT_HANDLER_AS_PROPERTY_DONT_RECEIVE_EVENT);
            Object[] args = new Object[]{event};
            Object[] propHandlerArgs = eventParam ? ArrayUtils.EMPTY_OBJECT_ARRAY : args;
            this.setCurrentEvent(event);
            try {
                ScriptResult scriptResult = eventListenersContainer.executeListeners(event, args, propHandlerArgs);
                return scriptResult;
            }
            finally {
                this.setCurrentEvent(null);
            }
        }
        return null;
    }

    @Override
    public boolean isConst(String name) {
        if ("undefined".equals(name) || "Infinity".equals(name) || "NaN".equals(name)) {
            return false;
        }
        return super.isConst(name);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public boolean dispatchEvent(Event event) {
        event.setTarget(this);
        ScriptResult result = Node.fireEvent(this, event);
        return !event.isAborted(result);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF, minVersion=10.0f), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public Object getOnchange() {
        return this.getHandlerForJavaScript("change");
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF, minVersion=10.0f), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void setOnchange(Object onchange) {
        this.setHandlerForJavaScript("change", onchange);
    }

    @JsxFunction
    public void postMessage(String message, String targetOrigin) {
        URL currentURL = this.getWebWindow().getEnclosedPage().getUrl();
        if (!"*".equals(targetOrigin)) {
            URL targetURL = null;
            try {
                targetURL = new URL(targetOrigin);
            }
            catch (Exception e) {
                Context.throwAsScriptRuntimeEx(new Exception("SyntaxError: An invalid or illegal string was specified."));
            }
            if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_POST_MESSAGE_ALLOW_INVALID_PORT) && Window.getPort(targetURL) != Window.getPort(currentURL)) {
                return;
            }
            if (!targetURL.getHost().equals(currentURL.getHost())) {
                return;
            }
            if (!targetURL.getProtocol().equals(currentURL.getProtocol())) {
                return;
            }
        }
        final MessageEvent event = new MessageEvent();
        String origin = currentURL.getProtocol() + "://" + currentURL.getHost() + ':' + currentURL.getPort();
        boolean cancelable = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_POST_MESSAGE_CANCELABLE);
        event.initMessageEvent("message", false, cancelable, message, origin, "", this);
        event.setParentScope(this);
        event.setPrototype(this.getPrototype(event.getClass()));
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_POST_MESSAGE_SYNCHRONOUS)) {
            this.dispatchEvent(event);
            return;
        }
        PostponedAction action = new PostponedAction(((DomNode)this.getDomNodeOrDie()).getPage()){

            @Override
            public void execute() throws Exception {
                Window.this.dispatchEvent(event);
            }
        };
        this.getWebWindow().getWebClient().getJavaScriptEngine().addPostponedAction(action);
    }

    private static int getPort(URL url) {
        int port = url.getPort();
        if (port == -1) {
            port = "http".equals(url.getProtocol()) ? 80 : 443;
        }
        return port;
    }

    private class DomHtmlAttributeChangeListenerImpl
    implements DomChangeListener,
    HtmlAttributeChangeListener {
        private DomHtmlAttributeChangeListenerImpl() {
        }

        @Override
        public void nodeAdded(DomChangeEvent event) {
            this.nodeChanged(event.getChangedNode(), null);
        }

        @Override
        public void nodeDeleted(DomChangeEvent event) {
            this.nodeChanged(event.getChangedNode(), null);
        }

        @Override
        public void attributeAdded(HtmlAttributeChangeEvent event) {
            this.nodeChanged(event.getHtmlElement(), event.getName());
        }

        @Override
        public void attributeRemoved(HtmlAttributeChangeEvent event) {
            this.nodeChanged(event.getHtmlElement(), event.getName());
        }

        @Override
        public void attributeReplaced(HtmlAttributeChangeEvent event) {
            this.nodeChanged(event.getHtmlElement(), event.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void nodeChanged(DomNode changed, String attribName) {
            String rel;
            if (changed instanceof HtmlStyle) {
                WeakHashMap weakHashMap = Window.this.computedStyles_;
                synchronized (weakHashMap) {
                    Window.this.computedStyles_.clear();
                }
                return;
            }
            if (changed instanceof HtmlLink && "stylesheet".equals(rel = ((HtmlLink)changed).getRelAttribute().toLowerCase(Locale.ENGLISH))) {
                WeakHashMap weakHashMap = Window.this.computedStyles_;
                synchronized (weakHashMap) {
                    Window.this.computedStyles_.clear();
                }
                return;
            }
            WeakHashMap weakHashMap = Window.this.computedStyles_;
            synchronized (weakHashMap) {
                boolean clearParents = ATTRIBUTES_AFFECTING_PARENT.contains(attribName);
                Iterator i = Window.this.computedStyles_.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    Object node = ((Node)entry.getKey()).getDomNodeOrDie();
                    if (changed != node && changed.getParentNode() != ((DomNode)node).getParentNode() && !changed.isAncestorOf((DomNode)node) && (!clearParents || !((DomNode)node).isAncestorOf(changed))) continue;
                    i.remove();
                }
            }
        }
    }
}

