/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.activex.javascript.msxml;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.MSXMLScriptable;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMDocument;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMDocumentFragment;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMElement;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMNodeList;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMSelection;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLSerializer;
import com.gargoylesoftware.htmlunit.html.DomCDataSection;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@JsxClass(browsers={@WebBrowser(value=BrowserName.IE)})
public class XMLDOMNode
extends MSXMLScriptable {
    private XMLDOMNodeList childNodes_;

    @JsxGetter
    public Object getAttributes() {
        return null;
    }

    @JsxGetter
    public String getBaseName() {
        Object domNode = this.getDomNodeOrDie();
        String baseName = ((DomNode)domNode).getLocalName();
        if (baseName == null) {
            return "";
        }
        return baseName;
    }

    @JsxGetter
    public XMLDOMNodeList getChildNodes() {
        if (this.childNodes_ == null) {
            Object domNode = this.getDomNodeOrDie();
            boolean isXmlPage = ((DomNode)domNode).getOwnerDocument() instanceof XmlPage;
            Boolean xmlSpaceDefault = XMLDOMNode.isXMLSpaceDefault(domNode);
            boolean skipEmptyTextNode = isXmlPage && !Boolean.FALSE.equals(xmlSpaceDefault);
            this.childNodes_ = new XMLDOMNodeList((DomNode)domNode, false, "XMLDOMNode.childNodes", (DomNode)domNode, skipEmptyTextNode){
                final /* synthetic */ DomNode val$domNode;
                final /* synthetic */ boolean val$skipEmptyTextNode;
                {
                    this.val$domNode = domNode;
                    this.val$skipEmptyTextNode = bl;
                    super(x0, x1, x2);
                }

                @Override
                protected List<Object> computeElements() {
                    ArrayList<Object> response = new ArrayList<Object>();
                    for (DomNode child : this.val$domNode.getChildren()) {
                        if (this.val$skipEmptyTextNode && child instanceof DomText && !(child instanceof DomCDataSection) && StringUtils.isBlank(((DomText)child).getNodeValue())) continue;
                        response.add(child);
                    }
                    return response;
                }
            };
        }
        return this.childNodes_;
    }

    private static Boolean isXMLSpaceDefault(DomNode node) {
        while (node instanceof DomElement) {
            String value = ((DomElement)node).getAttribute("xml:space");
            if (!value.isEmpty()) {
                if ("default".equals(value)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            node = node.getParentNode();
        }
        return null;
    }

    @JsxGetter
    public String getDataType() {
        return null;
    }

    @JsxGetter
    public String getDefinition() {
        return null;
    }

    @JsxGetter
    public XMLDOMNode getFirstChild() {
        Object domNode = this.getDomNodeOrDie();
        return this.getJavaScriptNode(((DomNode)domNode).getFirstChild());
    }

    @JsxGetter
    public XMLDOMNode getLastChild() {
        Object domNode = this.getDomNodeOrDie();
        return this.getJavaScriptNode(((DomNode)domNode).getLastChild());
    }

    @JsxGetter
    public String getNamespaceURI() {
        Object domNode = this.getDomNodeOrDie();
        String namespaceURI = ((DomNode)domNode).getNamespaceURI();
        if (namespaceURI == null) {
            return "";
        }
        return namespaceURI;
    }

    @JsxGetter
    public XMLDOMNode getNextSibling() {
        Object domNode = this.getDomNodeOrDie();
        return this.getJavaScriptNode(((DomNode)domNode).getNextSibling());
    }

    @JsxGetter
    public String getNodeName() {
        Object domNode = this.getDomNodeOrDie();
        return ((DomNode)domNode).getNodeName();
    }

    @JsxGetter
    public short getNodeType() {
        Object domNode = this.getDomNodeOrDie();
        return ((DomNode)domNode).getNodeType();
    }

    @JsxGetter
    public String getNodeValue() {
        Object domNode = this.getDomNodeOrDie();
        return ((DomNode)domNode).getNodeValue();
    }

    @JsxSetter
    public void setNodeValue(String value) {
        if (value == null || "null".equals(value)) {
            throw Context.reportRuntimeError("Type mismatch.");
        }
        Object domNode = this.getDomNodeOrDie();
        ((DomNode)domNode).setNodeValue(value);
    }

    @JsxGetter
    public Object getOwnerDocument() {
        Object domNode = this.getDomNodeOrDie();
        Document document = ((DomNode)domNode).getOwnerDocument();
        if (document == null) {
            return null;
        }
        return ((SgmlPage)document).getScriptObject();
    }

    @JsxGetter
    public Object getParentNode() {
        Object domNode = this.getDomNodeOrDie();
        return this.getJavaScriptNode(((DomNode)domNode).getParentNode());
    }

    @JsxGetter
    public String getPrefix() {
        Object domNode = this.getDomNodeOrDie();
        String prefix = ((DomNode)domNode).getPrefix();
        if (prefix == null || ((DomNode)domNode).getHtmlPageOrNull() != null) {
            return "";
        }
        return prefix;
    }

    @JsxGetter
    public XMLDOMNode getPreviousSibling() {
        Object domNode = this.getDomNodeOrDie();
        return this.getJavaScriptNode(((DomNode)domNode).getPreviousSibling());
    }

    @JsxGetter
    public Object getText() {
        Object domNode = this.getDomNodeOrDie();
        return ((DomNode)domNode).getTextContent();
    }

    @JsxSetter
    public void setText(Object text) {
        Object domNode = this.getDomNodeOrDie();
        ((DomNode)domNode).setTextContent(text == null ? null : Context.toString(text));
    }

    @JsxGetter
    public Object getXml() {
        String xml;
        Object domNode = this.getDomNodeOrDie();
        if (this instanceof XMLDOMElement) {
            boolean preserveWhiteSpace = ((XMLDOMDocument)this.getOwnerDocument()).isPreserveWhiteSpaceDuringLoad();
            XMLSerializer serializer = new XMLSerializer(preserveWhiteSpace);
            xml = serializer.serializeToString(this);
        } else {
            xml = ((DomNode)domNode).asXml();
        }
        if (xml.endsWith("\r\n")) {
            xml = xml.substring(0, xml.length() - 2);
        }
        return xml;
    }

    @JsxFunction
    public Object appendChild(Object newChild) {
        if (newChild == null || "null".equals(newChild)) {
            throw Context.reportRuntimeError("Type mismatch.");
        }
        Object appendedChild = null;
        if (newChild instanceof XMLDOMNode) {
            XMLDOMNode childNode = (XMLDOMNode)newChild;
            Object childDomNode = childNode.getDomNodeOrDie();
            Object parentNode = this.getDomNodeOrDie();
            ((DomNode)parentNode).appendChild((Node)childDomNode);
            appendedChild = newChild;
            if (!(parentNode instanceof SgmlPage) && !(this instanceof XMLDOMDocumentFragment) && ((DomNode)parentNode).getParentNode() == null) {
                DomDocumentFragment fragment = ((DomNode)parentNode).getPage().createDomDocumentFragment();
                fragment.appendChild((Node)parentNode);
            }
        }
        return appendedChild;
    }

    @JsxFunction
    public Object cloneNode(boolean deep) {
        Object domNode = this.getDomNodeOrDie();
        DomNode clonedNode = ((DomNode)domNode).cloneNode(deep);
        XMLDOMNode jsClonedNode = this.getJavaScriptNode(clonedNode);
        return jsClonedNode;
    }

    @JsxFunction
    public boolean hasChildNodes() {
        Object domNode = this.getDomNodeOrDie();
        return ((DomNode)domNode).getChildren().iterator().hasNext();
    }

    @JsxFunction
    public static Object insertBefore(Context context, Scriptable thisObj, Object[] args, Function function) {
        return ((XMLDOMNode)thisObj).insertBeforeImpl(args);
    }

    protected Object insertBeforeImpl(Object[] args) {
        Object newChildObject = args[0];
        Object refChildObject = args.length > 1 ? args[1] : Undefined.instance;
        Object appendedChild = null;
        if (newChildObject instanceof XMLDOMNode) {
            DomNode refChildNode;
            XMLDOMNode newChild = (XMLDOMNode)newChildObject;
            Object newChildNode = newChild.getDomNodeOrDie();
            if (newChildNode instanceof DomDocumentFragment) {
                DomDocumentFragment fragment = (DomDocumentFragment)newChildNode;
                for (DomNode child : fragment.getChildren()) {
                    this.insertBeforeImpl(new Object[]{child.getScriptObject(), refChildObject});
                }
                return newChildObject;
            }
            if (refChildObject == Undefined.instance) {
                if (args.length > 1) {
                    throw Context.reportRuntimeError("Invalid argument.");
                }
                refChildNode = null;
            } else {
                refChildNode = refChildObject != null ? (DomNode)((XMLDOMNode)refChildObject).getDomNodeOrDie() : null;
            }
            Object domNode = this.getDomNodeOrDie();
            if (refChildNode != null) {
                refChildNode.insertBefore((DomNode)newChildNode);
                appendedChild = newChildObject;
            } else {
                ((DomNode)domNode).appendChild((Node)newChildNode);
                appendedChild = newChildObject;
            }
            if (((DomNode)domNode).getParentNode() == null) {
                DomDocumentFragment fragment = ((DomNode)domNode).getPage().createDomDocumentFragment();
                fragment.appendChild((Node)domNode);
            }
        }
        return appendedChild;
    }

    @JsxFunction
    public Object removeChild(Object childNode) {
        Object removedChild = null;
        if (childNode instanceof XMLDOMNode) {
            Object childDomNode = ((XMLDOMNode)childNode).getDomNodeOrDie();
            ((DomNode)childDomNode).remove();
            removedChild = childNode;
        }
        return removedChild;
    }

    @JsxFunction
    public Object replaceChild(Object newChild, Object oldChild) {
        Object removedChild = null;
        if (newChild instanceof XMLDOMDocumentFragment) {
            XMLDOMDocumentFragment fragment = (XMLDOMDocumentFragment)newChild;
            XMLDOMNode firstNode = null;
            XMLDOMNode refChildObject = ((XMLDOMNode)oldChild).getNextSibling();
            for (DomNode node : ((DomNode)fragment.getDomNodeOrDie()).getChildren()) {
                if (firstNode == null) {
                    this.replaceChild(node.getScriptObject(), oldChild);
                    firstNode = (XMLDOMNode)node.getScriptObject();
                    continue;
                }
                this.insertBeforeImpl(new Object[]{node.getScriptObject(), refChildObject});
            }
            if (firstNode == null) {
                this.removeChild(oldChild);
            }
            removedChild = oldChild;
        } else if (newChild instanceof XMLDOMNode && oldChild instanceof XMLDOMNode) {
            XMLDOMNode newChildNode = (XMLDOMNode)newChild;
            Object newChildDomNode = newChildNode.getDomNodeOrDie();
            Object oldChildDomNode = ((XMLDOMNode)oldChild).getDomNodeOrDie();
            ((DomNode)oldChildDomNode).replace((DomNode)newChildDomNode);
            removedChild = oldChild;
        }
        return removedChild;
    }

    @JsxFunction
    public XMLDOMSelection selectNodes(String expression) {
        Object domNode = this.getDomNodeOrDie();
        boolean attributeChangeSensitive = expression.contains("@");
        XMLDOMSelection collection = new XMLDOMSelection((DomNode)domNode, attributeChangeSensitive, "XMLDOMNode.selectNodes('" + expression + "')", (DomNode)domNode, expression){
            final /* synthetic */ DomNode val$domNode;
            final /* synthetic */ String val$expression;
            {
                this.val$domNode = domNode;
                this.val$expression = string;
                super(x0, x1, x2);
            }

            @Override
            protected List<Object> computeElements() {
                return new ArrayList<Object>(this.val$domNode.getByXPath(this.val$expression));
            }
        };
        return collection;
    }

    @JsxFunction
    public Object selectSingleNode(String expression) {
        XMLDOMSelection collection = this.selectNodes(expression);
        if (collection.getLength() > 0) {
            return collection.get(0, (Scriptable)collection);
        }
        return null;
    }

    protected XMLDOMNode getJavaScriptNode(DomNode domNode) {
        if (domNode == null) {
            return null;
        }
        return (XMLDOMNode)this.getScriptableFor(domNode);
    }
}

