# -*- coding: utf-8 -*-

##
# Távoli klienshez csatlakozás linux OS alól
##

import sys, os, time, subprocess, glob

##
# A távoli klienshez csatlakozás valósítja meg
# NX és RDP esetén a remmina programot hívja meg. Ha a remmina-ban még nem szerepel
# a kliens, a program elkészíti az indításhoz szükséges profilt.
# @param vm Paraméterek a csatlakozáshoz
#   vm.protocol  SSH, NX és RDP lehetséges
#   vm.host      A virtuális gép címe
#   vm.port      Ezen a porton csatlakozunk a virtuális géphez
#   vm.user      Csatlakozáshoz használt név
#   vm.password  Csatlakozáshoz használt jelszó
#
def connect(vm):
    if vm.protocol == "SSH":
        command = "sshpass -p %s ssh -p %s -o StrictHostKeyChecking=no %s@%s" % (vm.password, vm.port, vm.user, vm.host)
        subprocess.call(command, shell=True)
    elif vm.protocol in ("NX", "RDP"):
        server = "%s:%s" % (vm.host, vm.port)
        listdir = os.path.expanduser("~/.remmina/*.remmina")
        found = False
        for config_file in glob.glob(listdir):
            with open(config_file) as f:
                if server in f.read():
                    found = True
                    break
        if not found:
            config_file = "%s%s%s" % (os.path.expanduser("~/.remmina/"), str(int(time.time()*1000)), ".remmina")
            password = subprocess.check_output(["remminapasswd", vm.password])
            f = open(config_file, 'w')
            if vm.protocol == "NX":
                f.write(NX_template)
            else:
                f.write(RDP_template)
            f.write("name=%s:%s\nprotocol=%s\nserver=%s\nusername=%s\npassword=%s\n" % (vm.protocol, server, vm.protocol, server, vm.user, password))
            f.close()
        subprocess.call(["remmina", "-c", config_file])

NX_template = """[remmina]
ssh_auth=0
quality=2
disableencryption=0
ssh_charset=
ssh_privatekey=
resolution=
group=
ssh_loopback=0
exec=
ssh_username=
ssh_server=
ssh_enabled=0
nx_privatekey=
showcursor=0
disableclipboard=0
window_maximize=1
viewmode=4
"""

RDP_template = """[remmina]
disableclipboard=0
ssh_auth=0
clientname=
quality=2
ssh_charset=
ssh_privatekey=
console=0
resolution=
group=
ssh_loopback=0
shareprinter=0
ssh_username=
ssh_server=
security=
execpath=
sound=off
exec=
ssh_enabled=0
sharefolder=
domain=
colordepth=24
window_maximize=1
viewmode=4
"""
