from rest_framework import serializers
from .models import Flavor, Instance, Lease


class InstanceSerializer(serializers.ModelSerializer):
    lease = serializers.PrimaryKeyRelatedField(read_only=True)
    flavor = serializers.PrimaryKeyRelatedField(read_only=True)

    class Meta:
        model = Instance
        fields = (
                  "name",
                  "description",
                  "system",
                  "lease",
                  "flavor",
                  "password",
                  "template",
                  "time_of_suspend",
                  "time_of_delete")
        read_only_fields = ("password", "template", "time_of_suspend", "time_of_delete")


class FlavorSerializer(serializers.ModelSerializer):
    class Meta:
        model = Flavor
        fields = "__all__"


class LeaseSerializer(serializers.ModelSerializer):
    class Meta:
        model = Lease
        fields = '__all__'
