"""
Django settings for recircle project.

Generated by 'django-admin startproject' using Django 2.1.7.

For more information on this file, see
https://docs.djangoproject.com/en/2.1/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/2.1/ref/settings/
"""

import os

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/2.1/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = "xhe8=w50lz82gjb6+z%(rwk2c+1kd!%(iv_s^!tp)*5cnb=-^t"

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = ["vm.niif.cloud.bme.hu", "localhost"]

# Application definition

INSTALLED_APPS = [
    "django.contrib.admin",
    "django.contrib.auth",
    "django.contrib.contenttypes",
    "django.contrib.sessions",
    "django.contrib.messages",
    "django.contrib.staticfiles",
    "rest_framework",
    "rest_framework.authtoken",
    "djoser",
    "rest_framework_swagger",
    "corsheaders",
    "guardian",
    "django_nose",
]

LOCAL_APPS = [
    "image",
    "instance",
    "storage",
    "template",
    "authorization",
]

INSTALLED_APPS += LOCAL_APPS

MIDDLEWARE = [
    "django.middleware.security.SecurityMiddleware",
    "django.contrib.sessions.middleware.SessionMiddleware",
    "corsheaders.middleware.CorsMiddleware",
    "django.middleware.common.CommonMiddleware",
    "django.middleware.csrf.CsrfViewMiddleware",
    "django.contrib.auth.middleware.AuthenticationMiddleware",
    "django.contrib.messages.middleware.MessageMiddleware",
    "django.middleware.clickjacking.XFrameOptionsMiddleware",
]

ROOT_URLCONF = "recircle.urls"

TEMPLATES = [
    {
        "BACKEND": "django.template.backends.django.DjangoTemplates",
        "DIRS": [],
        "APP_DIRS": True,
        "OPTIONS": {
            "context_processors": [
                "django.template.context_processors.debug",
                "django.template.context_processors.request",
                "django.contrib.auth.context_processors.auth",
                "django.contrib.messages.context_processors.messages",
            ]
        },
    }
]

WSGI_APPLICATION = "recircle.wsgi.application"


# Database
# https://docs.djangoproject.com/en/2.1/ref/settings/#databases

DATABASES = {
    "default": {
        "ENGINE": "django.db.backends.sqlite3",
        "NAME": os.path.join(BASE_DIR, "db.sqlite3"),
    }
}


# Password validation
# https://docs.djangoproject.com/en/2.1/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        "NAME": "django.contrib.auth.password_validation.UserAttributeSimilarityValidator"
    },
    {"NAME": "django.contrib.auth.password_validation.MinimumLengthValidator"},
    {"NAME": "django.contrib.auth.password_validation.CommonPasswordValidator"},
    {"NAME": "django.contrib.auth.password_validation.NumericPasswordValidator"},
]

REST_FRAMEWORK = {
    'DEFAULT_AUTHENTICATION_CLASSES': (
        'rest_framework.authentication.TokenAuthentication',
    ),
    'DEFAULT_SCHEMA_CLASS': 'rest_framework.schemas.coreapi.AutoSchema'  # needed for swagger
}

# Internationalization
# https://docs.djangoproject.com/en/2.1/topics/i18n/

LANGUAGE_CODE = "en-us"

TIME_ZONE = "Europe/Budapest"

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/2.1/howto/static-files/


STATIC_URL = "/static/"

###############################################################################
# RECIRCLE CONFIG
###############################################################################

# VM ACCESS PROTOCOLS
VM_ACCESS_PROTOCOLS = {
    "RDP": ["Remote Desktop Protocol", 3389, "tcp"],
    "SSH": ["Secure Shell", 22, "tcp"],
}

# LEASE TYPES
LEASE_TYPES = [
    {
        "name": "shortlab",
        "verbose_name": "Short laboratory",
        "description": "The student only needs the VM during the lecture.",
        "suspend_interval_seconds": 10800,  # 3 hours
        "delete_interval_seconds": 14400,  # 4 hours
    },
    {
        "name": "lab",
        "verbose_name": "Laboratory",
        "description": "The student may need the VM after the lecture.",
        "suspend_interval_seconds": 18000,  # 5 hours
        "delete_interval_seconds": 604800,  # 1 week
    },
    {
        "name": "project",
        "verbose_name": "Project",
        "description": "A VM is used for a project for a semester.",
        "suspend_interval_seconds": 2629743,  # 1 month
        "delete_interval_seconds": 15778463,  # 6 months
    },
]

# CORS config for development version only
CORS_ORIGIN_WHITELIST = ("http://localhost:3000",)

CONNECTION = {
    "auth_url":  os.getenv("OS_AUTH_URL"),
    "project_id":  os.getenv("OS_PROJECT_ID"),
    "project_name":  os.getenv("OS_PROJECT_NAME"),
    "user_domain_name":  os.getenv("OS_USER_DOMAIN_NAME", "Default"),
    "user_domain_id":  os.getenv("OS_USER_DOMAIN_ID", "default"),
    "project_domain_id":  os.getenv("OS_PROJECT_DOMAIN_ID", "default"),
    "username":  os.getenv("OS_USERNAME"),
    "password":  os.getenv("OS_PASSWORD"),
    "region_name":  os.getenv("OS_REGION_NAME"),
    "interface":  os.getenv("OS_INTERFACE"),
    "identity_api_version":  os.getenv("OS_IDENTITY_API_VERSION"),
}

# LOGGING = {
#     'version': 1,
#     'disable_existing_loggers': False,
#     'handlers': {
#         'file': {
#             'level': 'DEBUG',
#             'class': 'logging.FileHandler',
#             'filename': '/recircle/logs/django/debug.log',
#         },
#     },
#     'loggers': {
#         'django': {
#             'handlers': ['file'],
#             'level': 'DEBUG',
#             'propagate': True,
#         },
#     },
# }

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'simple': {
            'format': '%(asctime)s [%(levelname)s]: %(name)s %(message)s',
            'datefmt': '%Y-%m-%d %H:%M:%S',
        },
    },
    'handlers': {
        'console': {
            'class': 'logging.StreamHandler',
            'formatter': 'simple',
        },
    },
    'loggers': {
        'django': {
            'handlers': ['console'],
            'level': os.getenv('DJANGO_LOG_LEVEL', 'INFO'),
        },
    },
}

for i in LOCAL_APPS:
    LOGGING['loggers'][i] = {'handlers': ['console'], 'level': 'DEBUG'}

# Configure django-guardian for the authorization

AUTHENTICATION_BACKENDS = (
    'django.contrib.auth.backends.ModelBackend',  # this is default
    'guardian.backends.ObjectPermissionBackend',
)
