from django.db import models


class InstanceTemplate:

    """Virtual machine template.
    """

    name = models.CharField(
        max_length=100,
        verbose_name="name",
        help_text="Human readable name of template.",
    )
    description = models.TextField(
        verbose_name="description", blank=True, help_text="Description of the template."
    )
    # owner = models.ForeignKey(User)
    remote_ID = models.CharField(
        max_length=40,
        unique=True,
        verbose_name="remote_ID",
        help_text="ID, which helps access the template.",
    )
