from instance.models import Instance
from instance.serializers import InstanceSerializer
from django.http import Http404
from rest_framework.views import APIView
from rest_framework.response import Response
from rest_framework import status
from interface_openstack.implementation.vm.instance import OSVirtualMachineManager
import openstack

import datetime


conn = openstack.connect(cloud="openstack")


class InstanceList(APIView):
    def get(self, request, format=None):
        instances = Instance.objects.all()
        return Response(InstanceSerializer(instances, many=True).data)

    def post(self, request, format=None):
        data = request.data
        interface = OSVirtualMachineManager(conn)
        imageId = "da51253f-867c-472d-8ce0-81e7b7126d60"
        flavorId = "1"
        networks = [{"uuid": "c03d0d4b-413e-4cc6-9ebe-c0b5ca0dac3a"}]
        newBackendInstance = interface.create_vm_from_template(
            "Integration test vm 2", imageId, flavorId, networks
        )
        newInstance = Instance(
            name=data["name"],
            remote_id=newBackendInstance.id,
            description=data["description"],
            access_method="ssh",
            system=data["system"],
            password="12345678",
            lease=data["lease"],
            time_of_suspend=datetime.datetime.now(),
            time_of_delete=datetime.datetime.now(),
            deleted=False,
        )
        newInstance.save()
        return Response(newInstance.pk)


class InstanceDetail(APIView):
    """
    Retrieve, update or delete a snippet instance.
    """

    def get_object(self, pk):
        try:
            return Instance.objects.get(pk=pk)
        except Instance.DoesNotExist:
            raise Http404

    def get(self, request, pk, format=None):
        instance = self.get_object(pk)
        instanceDict = InstanceSerializer(instance).data

        interface = OSVirtualMachineManager(conn)
        remoteInstance = interface.get_vm(instance.remote_id)
        remoteInstanceDict = remoteInstance.__dict__

        merged_dict = {**instanceDict, **remoteInstanceDict}

        return Response(merged_dict)

    def put(self, request, pk, format=None):
        instance = self.get_object(pk)
        serializer = InstanceSerializer(instance, data=request.data)
        if serializer.is_valid():
            serializer.save()
            return Response(serializer.data)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)

    def delete(self, request, pk, format=None):
        instance = self.get_object(pk)
        instance.delete()
        return Response(status=status.HTTP_204_NO_CONTENT)
