from django.db import models
from django.conf import settings


ACCESS_METHODS = tuple(
    [(key, val[0]) for key, val in settings.VM_ACCESS_PROTOCOLS.items()]
)

# Later stored in database
LEASE_TYPES = tuple(
    [(val["name"], val["verbose_name"]) for val in settings.LEASE_TYPES]
)


class Instance(models.Model):
    name = models.CharField(max_length=100, help_text="Human readable name of instance")
    remote_id = models.CharField(
        max_length=100, help_text="ID of the instance on the backend"
    )
    description = models.TextField(
        blank=True, help_text="The description of the instance"
    )
    access_method = models.CharField(
        max_length=10, choices=ACCESS_METHODS, help_text="Primary remote access method"
    )
    system = models.CharField(max_length=50, help_text="Operating system type")
    password = models.CharField(
        max_length=50, help_text="Original password of the instance"
    )
    lease = models.CharField(
        max_length=50, choices=LEASE_TYPES, help_text="Expiration method"
    )
    time_of_suspend = models.DateTimeField(
        help_text="After this point in time, the instance will be suspended"
    )
    time_of_delete = models.DateTimeField(
        help_text="After this point in time, the instance will be deleted!"
    )
    deleted = models.BooleanField(
        help_text="Indicates if the instance is ready for garbage collection",
        default=False,
    )
    # template
    # disks
    # owner
