from image.models import Disk
from image.serializers import DiskSerializer
# from django.shortcuts import render
from rest_framework.views import APIView
from rest_framework.response import Response
from interface_openstack.implementation.image.OpenstackImageManager import (
    OpenstackImageManager,
)
import openstack

conn = openstack.connect(cloud="openstack")


class DiskList(APIView):
    def get(self, request, format=None):
        # OpenStack
        interface = OpenstackImageManager(conn)
        return Response([disk.__dict__ for disk in interface.list()])

        # Create response
        disks = Disk.object.all()
        serializer = DiskSerializer(disks, many=True)
        return Response(serializer.data)
