from django.db import models


class Disk(models.Model):

    """A virtual disk.
    """

    name = models.CharField(
        blank=True, max_length=100, verbose_name="name", help_text="Name of the disk"
    )
    remote_ID = models.CharField(
        max_length=40,
        unique=True,
        verbose_name="remote_ID",
        help_text="ID, which helps access the disk",
    )
