from rest_framework import serializers
from .models import Flavor, Instance


class InstanceSerializer(serializers.ModelSerializer):
    lease = serializers.PrimaryKeyRelatedField(read_only=True)
    flavor = serializers.PrimaryKeyRelatedField(read_only=True)

    class Meta:
        model = Instance
        fields = ("name", "description", "system", "lease", "flavor")


class FlavorSerializer(serializers.ModelSerializer):
    class Meta:
        model = Flavor
        fields = "__all__"
