# from django.shortcuts import render
from rest_framework.viewsets import ModelViewSet
from rest_framework.response import Response
from django.http import HttpResponse

from image.models import Image
from image.serializers import ImageSerializer


class ImageViewSet(ModelViewSet):
    serializer_class=ImageSerializer
    queryset=Image.objects.all()
    # def list(self, request):
    #     return HttpResponse("list")

    def create(self, request):
        serializer = ImageSerializer(data=request.data)
        serializer.is_valid(raise_exception=True)
        data = serializer.validated_data
        new_image =Image.create_from_user(
            description=data['description'],
            file_format=data['file_format'],
            image_file=data['image_file'],
            name=data['name'],
            user=request.user
        )
        serializer = ImageSerializer(instance=new_image)
        return Response(serializer.data)
    
    # def retrieve(self, request, pk=None):
    #     return HttpResponse("retrive")

    # def update(self, request, pk=None):
    #     return HttpResponse("update")

    # def partial_update(self, request, pk=None):
    #     return HttpResponse("patch")

    # def destroy(self, request, pk=None):
    #     return HttpResponse("delete")
