from rest_framework import serializers

from .models import Image


class ImageSerializer(serializers.ModelSerializer):
    image_file = serializers.FileField(write_only=True)
    file_format = serializers.CharField(max_length=10, write_only=True)

    class Meta:
        model = Image
        fields = (
            "name",
            "remote_id",
            "description",
            "image_file",
            "file_format",
            "created_at",
            "uploaded_by_user",
            "created_by",
        )
        read_only_fields = ("created_at", "uploaded_by_user", "created_by", "remote_id", )
