# import json
from asgiref.sync import async_to_sync
from channels.generic.websocket import WebsocketConsumer
from instance.models import Instance
from rest_framework.authtoken.models import Token
import logging
import json

logger = logging.getLogger(__name__)


class StatusConsumer(WebsocketConsumer):
    # Accept connection and wait for login message
    def connect(self):
        self.accept()

    # If login message arrives get the auth token from it
    # Then subscribe to the channels of the vm's that belongs to the user
    def login(self, auth_token):
        try:
            token = Token.objects.get(key=auth_token)
            self.user = token.user
            instances = Instance.objects.filter(created_by=self.user)
            for inst in instances:
                async_to_sync(self.channel_layer.group_add)(
                    str(inst.id),
                    self.channel_name
                )
        except Token.DoesNotExist:
            self.disconnect(100)

    # Unsubscribe from registered groups
    def disconnect(self, close_code):
        if hasattr(self, 'user'):
            instances = Instance.objects.filter(created_by=self.user)
            for inst in instances:
                async_to_sync(self.channel_layer.group_discard)(
                    str(inst.id),
                    self.channel_name
                )

    def receive(self, text_data):
        text_data_json = json.loads(text_data)
        type = text_data_json['type']
        if type == 'login':
            self.login(text_data_json['auth_token'])

    def status_changed(self, event):
        self.send(text_data=json.dumps({"vm": event["vm"], "status": event["status"]}))
