from django.dispatch import receiver
from django.db.models.signals import pre_delete
from django.conf import settings
from .models import Instance
from interface_openstack.implementation.vm.instance import (
                                                    OSVirtualMachineManager
                                                    )


@receiver(pre_delete, sender=Instance)
def delete_remote_instance(sender, instance, **kwargs):
    interface = OSVirtualMachineManager(settings.CONNECTION)
    interface.destroy_vm(instance.remote_id)
