# RECIRCLE Tervezési döntések

## Interface
### Kommunikáció módja az Cloud Managerrel (esetünkben OpenStack): [Apache libcloud](https://libcloud.apache.org/index.html) vagy [OpenStack SDK](https://docs.openstack.org/openstacksdk/rocky/)
__Apache libcloud__    
* + Több Cloud Manager-el is jól működik
* +- Valószínüleg jól működik OpenStack-el
* - Nem biztos, hogy minden OpS művelet szerepel benne úgy ahogy nekünk kell

__OpenStack SDK__ 
* + Jól működik Openstack-el  
* +- Máshol kell meghúzni a határokat a reuseability szempontjából

__Döntés__
Az OpenStack SDK mellett döntöttünk, mert így a Cloud Manager függő kódot egy magasabb szinten különíthetjük el az általánostól.

### Kommunikáció módja a klienssel: REST vagy MQ  
__REST__  
* + Viszonylag egyszerű  
* + Bizonyos műveletek nehezen kezelhetőek
* - 2 irányú kommunikáció nehézkes
   
__MQ__
* + 2 irányú kommunikációra jó
* - Nehézkes és bonyolult

__Döntés__
A REST mellett döntöttünk. Mind a *portal* mind az *interface* publikál egy REST API-t. Ez egyszerűen megvalósítható. Jó kiindulási pont.

### Authentikáció, authorizáció
Az authentikációra az OpenStack tartalmaz egy modult a Keystone-t. Ez egy jól specifikált és implementált modul, ám a céljainknak nem felel.  
__Problémák__ 
* Használatával megsértenénk azt a követelményt, hogy több Cloud Manager-t is támogasson a rendszer.
* Nem minden művelet végezhető el benne a jogosultságokkal kapcsolatban úgy, ahogy a mi üzleti logikánkban szerepel. (Szabolcsnál felmerült: nehéz a CIRCLE user-ek mappelése a keystone-os user fogalomhoz)
 
__Döntés__  
Saját authentikációt és authorizációt készítünk. Az OpenStack-es hívásokat egy projekthez tartozó admin user segítségével végezzük. Így nagy szabadságunk lesz a különböző userek jogainak meghatározásában.

Fontos, hogy mind a portal mind az interface authentikál. Az authorizációt a portal végzi.

### Hálózat és NAPT
Az OpenStack jelenlegi tudásunk szerint nem támogatja a NAPT-ot abban a formában, ahogy mi szeretnénk (1:portA -> n:portB). Amit tud az az nA:portA -> nB:portB. Ezért szükséges egy újabb hálózati réteg bevezetése.

### Kezdő projektstruktúra 
A fejlesztés elkezdéséhez egy Django szerverrel fogunk dolgozni, mely az openstacksdk interfacet python modul-ként használja. 

```
|------| REST |------| Python hívások |---------| OpS SDK |--------|  
|Client| <--> |Django| <------------> |Interface| <-----> |DevStack|  
|------|      |------|                |---------|         |--------|
```
### Devenv Setup

### Lease kezelés
Lease kezelés egyelőre nem lesz. A későbbiekben majd lesz valamilyen collector, ami időközönként lefut és ellenőrzi a suspended_at és a deleted_at változókat.
