from rest_framework import serializers

from template.models import ImageTemplate
from instance.serializers import FlavorSerializer, LeaseSerializer


class ImageTemplateListItemSerializer(serializers.ModelSerializer):
    flavor = FlavorSerializer(read_only=True)
    lease = LeaseSerializer(read_only=True)

    class Meta:
        model = ImageTemplate
        fields = ["id", "name", "distro", "flavor", "lease", "system_type"]
        read_only_fields = ("id", "name", "distro", "flavor", "lease", "system_type")


class InstanceFromTemplateSerializer(serializers.Serializer):
    name = serializers.CharField()
    description = serializers.CharField()


class ImageTemplateModelSerializer(serializers.ModelSerializer):
    class Meta:
        model = ImageTemplate
        fields = "__all__"
        read_only_fields = (
            "created_at",
            "created_by",
            "type",
            "id",
        )
