from django.test import TestCase
"""
from django.contrib.auth.models import User
from unittest.mock import Mock
from unittest.mock import patch

from image.models import Image
from instance.models import Instance
from instance.models import Flavor
from instance.models import Lease

from interface_openstack.interface.image.image import Image as RemoteImage
from interface_openstack.interface.vm.resources import Flavor as RemoteFlavor
from template.models import ImageTemplate
"""


class ImageModelsTest(TestCase):
    # Need review and rewrite because multiple changes in other modules
    # (Btw unit tests should not depend on other modules)
    pass


""" @staticmethod
    def create_user(name="test_user", email="test_email", password="test_password"):
        return User.objects.create_user(username=name, email=email, password=password)

    @staticmethod
    def create_flavor():
        with patch('instance.models.interface') as mock_interface:
            mock_interface.create_flavor.return_value = RemoteFlavor("123456789",
                                                                     "test_flavor",
                                                                     2, 1, 1)
            return Flavor.create("test_flavor", "test flavor description", 2, 1, 1, 2)

    def create_instance(self):
        params = {"name": "test_instance",
                  "description": "test instance description",
                  "access_protocol": "SSH",
                  "system": "LINUX",
                  "distro": "test_distro"
                  "time_of_suspend": "2019-05-28 23:59",
                  "time_of_delete": "2019-05-28 23:59",
                  }
        flavor = self.create_flavor()
        lease = Lease.objects.create(name="test_lease", description="test lease description",
                                     suspend_interval_in_sec=100, delete_interval_in_sec=100)
        owner = self.create_user("test_instance_user", "instance_user", "test_password")
        remote_id = "123456789"
        image = Image.objects.create(name="test_image", description="test image description",
                                     uploaded_by_user=True, remote_id="123456789123456789",
                                     created_by=owner)
        template = ImageTemplate.objects.create(name="test_template",
                                                description="test descripton",
                                                image=image,
                                                lease=lease,
                                                flavor=flavor,
                                                created_by=owner,
                                                type='U')
        return Instance.create(lease=lease, owner=owner, flavor=flavor,
                               remote_id=remote_id, template=template, params=params)

    def test_create_from_instance(self):
        with patch(
                'image.models.OSVirtualMachineManager'
        ) as mock_interface:
            mock_interface.create_image()
            mock_interface.return_value.create_image.return_value = RemoteImage("123456789",
                                                                                "987654321",
                                                                                "qcow2",
                                                                                "200000")
            user = self.create_user()
            instance = self.create_instance()
            description = "test image description"
            image = Image.create_from_instance(user, instance, description)
            self.assertEqual(image.name, "987654321")
            self.assertEqual(image.remote_id, "123456789")
            self.assertEqual(image.created_by_id, user.id)
            self.assertEqual(image.uploaded_by_user, False)
            self.assertEqual(image.description, description)

    def test_create_from_user(self):
        with patch('image.models.OpenstackImageManager') as mock_interface:
            mock_interface.upload_file()
            mock_interface.return_value.upload_file.return_value = RemoteImage("123456789",
                                                                               "987654321",
                                                                               "qcow2",
                                                                               "200000")
            description = "test image description"
            file_format = "qcow2"
            image_file = Mock()
            image_file.temporary_file_path()
            name = "test_image"
            user = self.create_user()
            image = Image.create_from_user(description, file_format, image_file, name, user)
            self.assertEqual(image.name, name)
            self.assertEqual(image.remote_id, "123456789")
            self.assertEqual(image.created_by_id, user.id)
            self.assertEqual(image.uploaded_by_user, True)
            self.assertEqual(image.description, description)
 """
