# Generated by Django 3.0.4 on 2020-04-06 12:09

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Disk',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, help_text='Name of the disk', max_length=100, verbose_name='name')),
                ('remote_id', models.CharField(help_text='ID, which helps access the disk', max_length=40, unique=True, verbose_name='remote_ID')),
            ],
        ),
        migrations.CreateModel(
            name='Image',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Human readable name of image.', max_length=100, verbose_name='name')),
                ('description', models.TextField(blank=True, help_text='Description of the image.', verbose_name='description')),
                ('remote_id', models.CharField(help_text='ID, which helps access the image.', max_length=40, unique=True, verbose_name='remote_ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, help_text='Date, when the image created.')),
                ('uploaded_by_user', models.BooleanField(default=True, editable=False, help_text='The field is false if the image created from instance')),
                ('created_by', models.ForeignKey(help_text='The user, who create the image', on_delete=django.db.models.deletion.DO_NOTHING, related_name='created_images', to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
