from guardian.shortcuts import get_objects_for_user

import logging

logger = logging.getLogger(__name__)


class AuthorizationMixin():

    authorization = {}

    def get_objects_with_perms(self, user, method, instance):
        auth_params = self.authorization[method]
        if auth_params:
            return get_objects_for_user(user, auth_params["filter"], instance)
        else:
            logger.error(f"Invalid method for authorization: {method}")
            return False

    def has_perms_for_object(self, user, method, instance):
        auth_params = self.authorization[method]
        if auth_params:
            for perm in auth_params["object"]:
                if not user.has_perm(perm, instance):
                    return False
            return True
        else:
            logger.error(f"Invalid method for authorization: {method}")
            return False

    def has_perms_for_model(self, user, method):
        auth_params = self.authorization[method]
        if auth_params:
            for perm in auth_params["model"]:
                if not user.has_perm(perm):
                    return False
            return True
        else:
            logger.error(f"Invalid method for authorization: {method}")
            return False
