from rest_framework.response import Response
from rest_framework.viewsets import ModelViewSet

from template.serializers import ImageTemplateModelSerializer
from template.models import ImageTemplate


class ImageTemplateViewSet(ModelViewSet):
    serializer_class = ImageTemplateModelSerializer
    queryset = ImageTemplate.objects.all()

    def create(self, request):
        serializer = ImageTemplateModelSerializer(data=request.data)
        serializer.is_valid(raise_exception=True)
        data = serializer.validated_data
        new_template = ImageTemplate.create(
            name=data["name"],
            description=data["description"],
            created_by=request.user,
            image=data["image"],
            lease=data["lease"],
            flavor=data["flavor"],
            type="U"
        )
        serializer = ImageTemplateModelSerializer(instance=new_template)
        return Response(serializer.data)

    def update(self, request, *args, **kwargs):
        # only the name, description, lease, flavor can be updated
        allowed_keys = ["name", "description", "lease", "flavor"]

        # delete not allowed key
        for key in request.data.keys():
            if key not in allowed_keys:
                request.data.pop(key, None)

        return super(ImageTemplateViewSet, self).update(request, partial=True)
