from rest_framework import serializers

from template.models import ImageTemplate


class InstanceFromTemplateSerializer(serializers.Serializer):
    name = serializers.CharField()
    description = serializers.CharField()


class ImageTemplateModelSerializer(serializers.ModelSerializer):
    class Meta:
        model = ImageTemplate
        fields = (
            "id",
            "name",
            "description",
            "created_at",
            "created_by",
            "image",
            "flavor",
            "lease",
            "type",
        )
        read_only_fields = (
            "created_at",
            "created_by",
            "type",
            "id",
        )
