# Generated by Django 3.0.4 on 2020-03-26 11:58

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('image', '__first__'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('instance', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='BaseTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Human readable name of template.', max_length=100, verbose_name='name')),
                ('description', models.TextField(blank=True, help_text='Description of the template.', verbose_name='description')),
                ('created_at', models.DateTimeField(auto_now_add=True, help_text='Date, when the template created.')),
                ('network_id', models.CharField(blank=True, help_text='The new instance will be in this network.', max_length=100, null=True, verbose_name='network_id')),
                ('created_by', models.ForeignKey(help_text='The user, who create the template', on_delete=django.db.models.deletion.DO_NOTHING, related_name='created_templates', to=settings.AUTH_USER_MODEL)),
                ('flavor', models.ForeignKey(help_text='Resources given to the vm', on_delete=django.db.models.deletion.CASCADE, related_name='templates', to='instance.Flavor', verbose_name='flavor')),
                ('lease', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='templates', to='instance.Lease')),
            ],
        ),
        migrations.CreateModel(
            name='ImageTemplate',
            fields=[
                ('basetemplate_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='template.BaseTemplate')),
                ('type', models.CharField(choices=[('U', 'User create the template from image'), ('I', 'Template created from instance'), ('P', '"Pure" template')], default='U', max_length=10)),
                ('image', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='templates', to='image.Image')),
            ],
            bases=('template.basetemplate',),
        ),
        migrations.CreateModel(
            name='DiskTemplate',
            fields=[
                ('basetemplate_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='template.BaseTemplate')),
                ('disk', models.ForeignKey(help_text='The disk where the template is located.', on_delete=django.db.models.deletion.CASCADE, related_name='templates', to='image.Disk')),
            ],
            bases=('template.basetemplate',),
        ),
    ]
