# Generated by Django 3.0.4 on 2020-03-26 11:58

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('image', '__first__'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Flavor',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=100)),
                ('description', models.CharField(blank=True, max_length=200)),
                ('remote_id', models.CharField(help_text='ID of the instance on the backend', max_length=100)),
                ('ram', models.IntegerField(blank=True, null=True)),
                ('vcpu', models.IntegerField(blank=True, null=True)),
                ('initial_disk', models.IntegerField(blank=True, null=True)),
                ('priority', models.IntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Lease',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=100)),
                ('description', models.CharField(blank=True, max_length=100)),
                ('suspend_interval_in_sec', models.IntegerField(blank=True, null=True)),
                ('delete_interval_in_sec', models.IntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Instance',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Human readable name of instance', max_length=100)),
                ('remote_id', models.CharField(help_text='ID of the instance on the backend', max_length=100)),
                ('description', models.TextField(blank=True, help_text='The description of the instance')),
                ('access_method', models.CharField(choices=[('rdp', 'Remote Desktop Protocol'), ('ssh', 'Secure Shell')], help_text='Primary remote access method', max_length=10)),
                ('system', models.CharField(help_text='Operating system type', max_length=50)),
                ('password', models.CharField(help_text='Original password of the instance', max_length=50)),
                ('time_of_suspend', models.DateTimeField(blank=True, help_text='After this point in time, the instance will be suspended')),
                ('time_of_delete', models.DateTimeField(blank=True, help_text='After this point in time, the instance will be deleted!')),
                ('deleted', models.BooleanField(default=False, help_text='Indicates if the instance is ready for garbage collection')),
                ('disks', models.ManyToManyField(help_text='Disks attached to instance', related_name='instance', to='image.Disk', verbose_name='disks')),
                ('flavor', models.ForeignKey(help_text='Reasources given to the vm', on_delete=django.db.models.deletion.CASCADE, related_name='instances', to='instance.Flavor', verbose_name='flavor')),
                ('lease', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='instances', to='instance.Lease')),
                ('owner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'permissions': (('create_instance', 'Can create a new VM.'), ('create_template_from_instance', 'Can create template from instance.'), ('use_instance', 'Can access the VM connection info.'), ('operate_instance', 'Can use basic lifecycle methods of the VM.'), ('administer_instance', 'Can delete VM.'), ('access_console', 'Can access the graphical console of a VM.'), ('change_resources', 'Can change resources of a VM.'), ('manage_access', 'Can manage access rights for the VM.'), ('config_ports', 'Can configure port forwards.')),
                'default_permissions': (),
            },
        ),
    ]
