import openstack
import Image
import ImageManager


class OpenstackImageManager(ImageManager.ImageManager):

    def __init__(self, cloud) -> None:
        super().__init__()
        self.openstack = openstack.connect(cloud=cloud)

    @staticmethod
    def os_image_to_rc_image(os_image):
        return Image.Image(
            os_image.id,
            os_image.name,
            os_image.disk_format
        )

    def upload_file(self, path):
        os_image = self.openstack.image.create_image(name=path, filename=path, disk_format='iso')

        return self.os_image_to_rc_image(os_image)

    def get(self, id):
        os_image = self.openstack.image.get_image(id)

        return self.os_image_to_rc_image(os_image)

    def delete(self, id):
        self.openstack.image.delete_image(id)

    def list(self):
        images = []

        for os_image in self.openstack.image.images():
            images.append(self.os_image_to_rc_image(os_image))

        return images
