/*
 * Demonstrációs program virtualis destruktor működésére.
 * Az alaposztály destruktora a VIRTUAL makrótól függően
 * virtuális, vagy nem.
 * Fordítsa le a programot mindkét változatban és probálja ki.
 * A nem virtulális változat memória szivárgást jelez.
 *
 * UNIX/LINUX környezetben a fordítást, és futtatást make segíti:
 *   Fordítás: make
 *      Két program készül: virtDestr és nemVirtDestr
 *   Futtatás: make run
 */
#ifndef MEMTRACE
# define MEMTRACE       // ha nem definiált akkor definiáljuk
#endif // MEMTRACE
#include "memtrace.h"

/// A VIRTUAL makró vagy üres, vagy virtual kulcsszót tartalmaz
#ifndef VIRTUAL         // ha nem definiált akkor üres lesz
# define VIRTUAL
#endif // VIRTUAL

struct  A {
   VIRTUAL ~A() {};
};

/// Amennyiben az alaposztály destruktora nem virtuális,
/// akkor nem fog meghívódni a származtatott osztály destruktora.
class B :public A {
    char *p;
public:
    B() { p=new char[10];}
    ~B() { delete[] p; }
};

int main() {
    A *pa = new B;
    delete pa;      /// B példányát alaposztály típusú pointeren keresztül érjük el.
                    /// Ezért csak az alaposztály destruktora hívódik, ha az nem
                    /// virtuális.
    return 0;
}
