/*
 * Demonstrációs program tipikus hibára, ami memória szivárgást okoz.
 * A hiba UNIX/LINUX környezetben demonstrálható könnyen, mivel ott a
 * futtatandó program heap használata könnyen korlátozható.
 * Fordítás: make
 *   Két program készül: virtDestr és nemVirtDestr
 * Futtatás: make run
 *   Futtatáskor korlátozzuk a heap méretét ami a nemVirtDestr változatnak nem elég
 */

#include <iostream>
#include <cstdlib>

/// A VIRTUAL makró vagy üres, vagy virtual kulcsszót tartalmaz
#ifndef VIRTUAL        // ha nem definiált akkor üres lesz
# define VIRTUAL
#endif // VIRTUAL

struct  A {
    VIRTUAL ~A() {
        std::cout << '.';
    };
};

/// Amennyiben az alaposztály destruktora nem virtuális,
/// akkor nem fog meghívódni a származtatott osztály destruktora.
class B :public A {
    char *p;
public:
    B() { p=new char[1000];}
    ~B() { delete[] p; std::cout << '*'; }
};

int main(int argc, char *argv[]) {
    int num = 20;
    if (argc > 1)
        num = atoi(argv[1]);

    for (int i = 0; i < num; i++) {
        A *pa = new B;
        delete pa;      /// B példányát alaposztály típusú pointeren keresztül érjük el.
                        /// Ezért csak az alaposztály destruktora hívódik, ha az nem
                        /// virtuális.
    }
    std::cout << "\nVege" << std::endl;
    return 0;
}
