/**
 *  \file szin.h
 *  Szín osztály deklarációja
 */
#ifndef SZIN_H
#define SZIN_H

/// Szín osztály
/// Az egyszerűség kedvéért minden tagja publikus.
/// Így nem kell getter, meg setter, bár ronda megoldás.
struct Szin {
    Uint8 r, g, b;    ///< RGB
    Uint8 a;          ///< átlátszóság

    ///
    /// @param r - red
    /// @param g - green
    /// @param b - blue
    /// @param a - transparency
    Szin(Uint8 r = 0, Uint8 g = 0, Uint8 b = 0, Uint8 a = 255)
                        :r(r), g(g), b(b), a(a) {}

    /// cast Uint32-re
    operator Uint32() const { return (r << 24) + (g << 16) + (b << 8) + a; }
};

/// Színkontsansok
const Szin BLACK(0,0,0);
const Szin WHITE(255,255,255);
const Szin RED(255,0,0);
const Szin GREEN(0,255,0);
const Szin BLUE(0,0,255);
const Szin BACKGND = BLACK;

#endif // SZIN_H
