/**
 *  \file szakasz.h
 *  Szakasz osztály deklarációja
 */
#ifndef SZAKASZ_H
#define SZAKASZ_H

#include "alakzat.h"

/// Szakasz osztály
class Szakasz : public Alakzat {
    Pont pv;    ///< szakasz végpontja az origóhoz képest
public:
    /// konstruktor 2 pontból
    /// @param p0 - kezdőpont
    /// @param pv - végpont
    /// @param sz - szín és átlátszóság
    Szakasz(const Pont& p0, const Pont& pv, Szin sz)
                     : Alakzat(p0, sz), pv(p0-pv) { }

    /// konstruktor 1 pontból és 2 hosszból
    /// @param p0 - kezdőpont
    /// @param xl - x irányú hossz
    /// @param yl - y irányú hossz
    /// @param sz - szín és átlátszóság
    Szakasz(const Pont& p0, int xl, int yl, Szin sz)
                     : Alakzat(p0, sz), pv(Pont(xl, yl)) { }

    /// szakaszt rajzol
    void rajzol() const ;	// átdefiniáljuk a virt. fv-t.
};

#endif // SZAKASZ_H
