/**
 *  \file pont.h
 *  Pont osztály deklarációja
 */
#ifndef PONT_H
#define PONT_H

/// Pont osztály
/// Az egyszerűség kedvéért minden tagja publikus.
/// Igy nem kell getter, meg setter.
/// Csak azok az operatorok lettek megvalósítva, melyeket használ a demo
struct Pont {
    int x;
    int y;
    Pont(int x = 0, int y = 0) :x(x), y(y) {}

    /// += operator
    Pont& operator+=(const Pont& rhs_p) {
        x += rhs_p.x;
        y += rhs_p.y;
        return *this;
    }

    /// - operator
    Pont operator-(const Pont& rhs_p) const {
        return Pont(rhs_p.x-x, rhs_p.y-y);
    }
};

#endif // PONT_H
