/**
 *  \file main.cpp
 *  Bugyuta demó az SDL-lel kombinált alakzat osztályok kipróbálására.
 *  Felrajzol pár alakzatot, melyek az egérmozgással együtt mozognak.
 *  (csak az irányt követik, nem a mozgás nagyságát)
 */
#include <iostream>
#include <fstream>
#include "memtrace.h"
#include "szakasz.h"
#include "kor.h"

/// segédfüggvény az egérmozgáshoz
/// @param x - relatív elmozdulás
/// @return -1, 0, vagy 1 az elmozdulás irányától függően
inline int delta(int x) {
#ifdef DEMO
     return 0;
#else
     return x == 0 ? 0 : x < 0 ? -10 : 10;
#endif // DEMO
}

/// segédfüggvény az SDL inicializálásához
/// @return renderer pointer vagy 0
SDL_Renderer* init() {
    if (SDL_Init(SDL_INIT_EVERYTHING) < 0) {
        return 0;
    }
    SDL_Window *sdlWindow;
    SDL_Renderer *sdlRenderer;
    if (SDL_CreateWindowAndRenderer(640, 480, SDL_WINDOW_RESIZABLE, &sdlWindow, &sdlRenderer) < 0) {
        return 0;
    }
    SDL_RenderClear(sdlRenderer);

    return sdlRenderer;
}

int main(int argc, char* argv[]) {
    SDL_Renderer* renderer = init();
    if (renderer == NULL) {
        std::cerr << "Nem sikerult az inicializálás " << SDL_GetError() << std::endl;
        return 1;
    }

    Alakzat::setRenderer(renderer); // screen letárolása az "Alakzat-ba"

    const int N = 100;           // max 100 alakzatunk lehet
    Alakzat *idom[N];
    int db = 0;                  // most nincs egy se

    /// felrajzolunk egy szakaszt és egy kört
#ifndef DEMO
    idom[db++] = new Szakasz(Pont(20,40), 100, 0, WHITE);
    idom[db++] = new Kor(Pont(120,140), 50, BLUE);
#endif

    /// Eseménykezelõ ciklus.
    SDL_Event ev;
    while (SDL_WaitEvent(&ev) && ev.type != SDL_QUIT) {
        static bool drag = false;
        switch (ev.type) {
          case SDL_MOUSEMOTION:                 // egérmozgás esemény
            if (drag) {
                int dx = delta(ev.motion.xrel); // merre mozdult ?
                int dy = delta(ev.motion.yrel);
                for (int i = 0; i < db; i++) {  // végigmegyünk az összesen
                    idom[i]->mozgat(Pont(dx, dy));  // kicsit mozdítunk rajta
                    idom[i]->rajzol();          // kirajzoljuk
                }
                SDL_RenderPresent(renderer);
            }
            break;

          case SDL_WINDOWEVENT:
            if (ev.window.event == SDL_WINDOWEVENT_EXPOSED) {
                for (int i = 0; i < db; i++)    // végigmegyünk az összesen
                    idom[i]->rajzol();          // kirajzoljuk
            }
            SDL_RenderPresent(renderer);
            break;

          case SDL_MOUSEBUTTONDOWN:         // egérgomb kezelése
            if (ev.button.button == SDL_BUTTON_LEFT) {
                drag = true;
            } else if (db < N) {
                if (ev.button.button == SDL_BUTTON_MIDDLE)
                    idom[db] = new Szakasz(Pont(ev.button.x, ev.button.y), 40, 80, GREEN);
                else
                    idom[db] = new Kor(Pont(ev.button.x, ev.button.y), 40, RED);
                idom[db]->rajzol();
                ++db;
                SDL_RenderPresent(renderer);
            }
            break;

          case SDL_MOUSEBUTTONUP:         // egérgomb kezelése
            if (ev.button.button == SDL_BUTTON_LEFT)
                drag = false;
            break;
        }
    }
    for (int i = 0; i < db; i++) /// fel kell szabadítani minden objektumot
        delete idom[i];

    SDL_Quit();

    return 0;
}
