/**
 *  \file alakzat.h
 *  Alakzat alaposztály deklarációja
 */
#ifndef ALAKZAT_H
#define ALAKZAT_H
#include <SDL2/sdl.h>
#include <SDL2/SDL2_gfxPrimitives.h>
#include "pont.h"
#include "szin.h"

/// Alakzat absztrakt osztály
/// statikus tagként tárolja az SDL surface pointert
class Alakzat {
protected:
     Pont p0;                   ///< alakzat origója
     Szin sz;                   ///< alakzat színe
     static SDL_Renderer* renderer;   ///< eldugott globális változó
public:
    /// Konstruktor
    /// @param p0 - kezdőpont
    /// @param sz - szín és átlátszóság
    Alakzat(const Pont& p0, const Szin& sz) :p0(p0), sz(sz) {}

    /// Pozíció lekérdezése
    /// @return alakzat origója
    const Pont& getp0() const { return p0; }

    /// suface beállítása
    /// @param s - SDL surface
    static void setRenderer(SDL_Renderer* r) { renderer = r; }

    /// rajzol
    virtual void rajzol() const = 0;      // tisztán virtuális

    /// mozgat: origóját eltolja az új pontba
    /// @param d - eltolás vektora
    void mozgat(const Pont& d);

    /// Destruktor
    /// Ebben az alaposztályban nincs mit tennie, mivel nem tartalmaz
    /// dinamikus adattagot az alaposztály, de származtatottban még lehet.
    virtual ~Alakzat() {}
};

#endif // ALAKZAT_H
