# memsparse.py
import argparse
import re

def parse_memory_size(value):
    """
    Visszatér: memória méret MiB-ben (float).
    Elfogadott formák:
      - "4096"
      - "4G", "4g"
      - "4096M", "4096m"
      - "size=4194304k"
      - "4194304k"
    """
    # Red Hat stílus: size=4194304k
    if value.startswith('size='):
        value = value.split('=', 1)[1]

    m = re.match(r'^(\d+)([kKmMgG]?)$', value)
    if not m:
        raise argparse.ArgumentTypeError(
            "Invalid memory size format: %r" % value
        )

    num = int(m.group(1))
    suffix = m.group(2).lower()

    # QEMU unitok: k = KiB, m = MiB, g = GiB
    if suffix == 'k':
        mib = num / 1024.0
    elif suffix == 'm' or suffix == '':
        mib = float(num)
    elif suffix == 'g':
        mib = num * 1024.0
    else:
        # ide elvileg nem jutunk a regex miatt
        raise argparse.ArgumentTypeError(
            "Unsupported unit in memory size: %r" % suffix
        )

    return mib

