# GPU Virtualizáció

A gpu kártyák virtualizációját megnehezíti, hogy a gyártók bár azonos alapokon nyugvó kártyákat fejlesztenek ki, a hozzájuk tartozó driver-ek többnyire zártak és nem nyújtanak egységes képet a kezeléshez. Továbbá a kártyák fejlődésével minden gyártó a maga által kitalált technológiai irányvonalat / újítást követi, ami nem teszi lehetővé ezen kártyák egységes kezelését.

## Osztályozás

A virtuálizációhoz hasonlóan itt is a használt technológiától függően különböző fajta GPU virtualizációkról beszélhetünk.

 - **GPU passthrough** (kakukktojás): Nem virtualizációs technológia, de a host os lehetővé teszi egy virtuális gépnek a közvetlen PCI bus-on történő kommunikációt a kártyával. Hátránya: egyszerre csak egy VM használhatja, a használat kötött. Kevés veszteség.

 - **távoli API alapú**: A virtuális gépen speciális API könyvtár segítségével kommunikálunk a host-on keresztül a kártyával. Az API könyvtár egy wrapperhez hasonlítható, a rendes GPU hívásokat a wapper továbbítja a host-ra és az ottani API (CUDA, OpenCL, OpenGL) adja meg az eredményt.
 Mivel a módszer megkerüli a hypervisor réteget, ezért elenyésző többletköltséggel jár. A támogatott API-k rögzítettek, más API használata esetén a host-ot is újra kell konfigurálni, vagy frissíteni kell a wrapper könyvtárat, ha új funkciók kerülnek hozzáadásra a host GPU könyvtárához. Példák: GVirtuS (CUDA), DS-CUDA (CUDA), de nemcsak GPGPU wrapper-ek vannak.

![távoli API](img/remoteAPI.png)

 - **Para- vagy teljes virtualizáció**: A Hypervisor egy GPU eszközt emulál, ami a vendég virtuális géphez csatol. A kérések a vm driver-én keresztül először az emulált GPU-hoz futnak be. Az emulált GPU pedig a dedikált host GPU-t felhasználva végzi el a számításokat. A host GPU általában valamilyen sor alapú ütemező megoldást használ a virtuális gépek kiszolgálására.

![Paravirtualizáció vagy teljes virtualizációs megoldás](img/fullvirt.png)

 - **hardveres virtualizáció**: A vendég operációs rendszerek közvetlen hozzáférést kapnak a grafikus kártyához egy virtualizált I/O interfészen keresztül. Kezdetben csak egy VM használhatta egyszerre a kártyát, de elterjedtek a nagyobb 8-16 VM-et kiszolgálni képes megoldások is (NVIDIA GRID).

![hardveres virtualizáció](img/hardwaresup.png)

GPU passthrough megoldás esetén, mivel egyszerre csak egy virtuális gép használhat egy kártyát, felhő környezetben kevésbé jó megoldás, ugyanakkor ha a virtuális gép életciklusa viszonylag nagy, és az adott virtuális gép kihasználja közel 100\%-ban azt, akkor optimális megoldás lehet.

# Allokációs feladatok

Azon virtuális gépek, amik igényelnek GPU erőforrást, ahogy az előző szakasz is mutatja, a felhasználás módjától függően más-más ütemezési problémával nézünk szembe. Ha olyan megoldásról beszélünk, ahol egy GPU-hoz szigorúan csak egy virtuális gép csatolható, akkor a probléma egyszerű: A VM-et arra az adatközpontra és arra a node-ra kell ütemezni, ahol van teljesen szabad GPU kapacitás. Ekkor lényegében ugyanazt a megoldást használhatjuk, mint egy mezei virtuális gép ütemezésénél, de azokat a node-okat kell figyelembe venni, ahol van szabad GPU, így az ütemezési algoritmus csak a GPU-s node-ok kihasználtságán (vCPU, RAM...) fog alapulni. Még fontos információ, hogy jelenleg nem minden gyártó támogatja minden hypervisor-nál a vGPU-val csatolt virtuális gépek migrálását, pl. KVM esetén jelenleg ez nem elérhető. 

Ha egy GPU egyszerre több virtuális géphez is használható akkor az eddig tárgyalt erőforrás korlátok (pl. RAM) mellett, már figyelni kell a GPU kihasználtságára is, illetve arra, milyen típusú feladatra fogják használni a virtuális gépet (grafikai vagy GPGPU). Jelenleg érvényeg allokációs stratégiák a Citrix Hypervisor és VMware vSpehere esetén NVIDIA kártya mellett

 - **breadth-first** (maximális teljesítmény): A VGPU-kat igyekszik kiteríteni a fizikai GPU-k között: Az új virtuális GPU arra a fizikai kártyára kerül, ami támogatja az adott virtuális típust, illetve a legkevesebb VGPU van hozzátársítva.
 - **deep-first** (maximális kihasználtság): Igyekszik maximalizáni az egyes fizikai GPU-k kihasználtságát: Az új virtuális GPU arra a fizikai kártyára kerül, ami támogatja az adott virtuális típust, illetve a legtöbb VGPU van hozzátársítva. Ez a módszer kihasználtáságot növelheti és így a költségeket csökkentheti, ugyanakkor a teljesítmény romlik.

# Ütemezési feladatok

A hardweres különbségek miatt, az eszközillesztők elrejtik a GPU multiplexelésének módszereit, így nehezen kényszeríthetők rajtuk ki, hogy valamilyen ütemezési politikát kövessenek (a gyártótól függetlenül). Most is az NVIDIA kártyák VGPU ütemezési lehetőségeket nézzük meg:

 - best effort: Cél a GPU cycle-ek maximális kihasználása, az üresjáratokat osztja ki az új kéréseknek. Egy grafika-intenzív virtuális gép ronthatja más virtuális gépek grafikai teljesítményét is. (noisy neighbor protection) Nincs garantált szolgáltatásminőség.
 - Időszeletelt, egyenlő részesedésű ütemező (Time-sliced vgpu, equal share scheduler): A virtuális GPU-k egyenlő arányban használják a fizikai kártya feldolgozási ciklusát. Ha egy VGPU leáll, akkor a maradék VGPU teljesítménye nő (több időszelet), ha új érkezik, akkor csökken. 
 - Időszeletelt, fix részesedésű ütemező (Time-sliced vgpu, fix share scheduler): A használt virtuális GPU-tól függően fix méretű időszelet jut egy-egy VGPU-nak. A virtuális kártyák teljesítményét érdemben nem befolyásolja, ha egy új VGPU-t kell kiosztani, vagy az egyiket meg kell szüntetni.

 Az időszeletelt megoldásoknál a virtuális gépek sorosan, egymás után jutnak szabad feldolgozási ciklushoz. Az időszelet beállítható a felhasználás módjától függően: Grafikai alkalmazások esetén, mivel viszonylag kicsi (de sok), gyorsan elvégezhető számításról beszélünk, ezért rövidebb időszelettel érhető el maximális teljesítmény. A rövidebb időszelet csökkenti a késleltetést, mivel gyakrabban vált. Míg a maximális átviteli sebességet igénylő terhelésnél nagyobb időszelet az optimális.

# Források
 - Cheol-Ho Hong, Ivor Spence, and Dimitrios S. Nikolopoulos. 2017. GPU Virtualization and Scheduling Methods: A Comprehensive Survey. ACM Comput. Surv. 50, 3, Article 35 (May 2018), 37 pages. https://doi.org/10.1145/3068281
 - Virtual GPU Software Documentation - NVIDIA: https://docs.nvidia.com/grid/14.0/grid-vgpu-user-guide/index.html