from rest_framework.renderers import JSONRenderer
from rest_framework import serializers
from django.contrib.auth.models import Group, User

from vm.models import Instance, InstanceTemplate, Lease, Interface, Node, InstanceActivity
from firewall.models import Vlan
from storage.models import Disk, StorageActivity

class InstanceActivitySerializer(serializers.ModelSerializer):
    get_percentage = serializers.IntegerField()
    result_data = serializers.JSONField()

    class Meta:
        model = InstanceActivity
        fields = ('id', 'instance', 'resultant_state', 'interruptible', 'activity_code', 'parent', 
                    'task_uuid', 'user', 'started', 'finished', 'succeeded', 'result_data', 'created', 'modified', 'get_percentage')

class StorageActivitySerializer(serializers.ModelSerializer):

    class Meta:
        model = StorageActivity
        fields = ('id', 'parent', 'task_uuid', 'user', 'started', 'finished', 'succeeded', 'result_data', 'created', 'modified', 'disk')

    

class GroupSerializer(serializers.ModelSerializer): 
    class Meta:
        model = Group
        fields = ('id', 'name', 'user_set')

class UserSerializer(serializers.ModelSerializer):    
    class Meta:
        model = User
        fields = ('id', 'username', 'email', 'is_staff', 'groups', 'is_superuser', 'first_name', 'last_name')


class NodeSerializer(serializers.ModelSerializer):
    class Meta:
        model = Node
        fields = [ 'id', 'name', 'priority', 'host', 'enabled', 'schedule_enabled',
                    'traits', 'overcommit', 'ram_weight', 'cpu_weight', 'time_stamp' ]


class InstanceTemplateSerializer(serializers.ModelSerializer):
    class Meta:
        model = InstanceTemplate
        fields = [ 'id', 'name', 'description', 'parent', 'owner', 'access_method', 'boot_menu', 
                    'lease', 'raw_data', 'cloud_init', 'ci_meta_data', 'ci_user_data', 'system',
                    'has_agent', 'num_cores', 'ram_size', 'max_ram_size', 'arch', 'priority', 'disks']


class LeaseSerializer(serializers.ModelSerializer):
    class Meta:
        model = Lease
        fields = [ 'id', 'name', 'suspend_interval_seconds', 'delete_interval_seconds']


class DiskSerializer(serializers.ModelSerializer):
    class Meta:
        model = Disk
        fields = ['id', 'name', 'filename', 'datastore', 'type', 'bus', 'size', 'base',
                    'dev_num', 'destroyed', 'ci_disk', 'is_ready']


class InstanceSerializer(serializers.ModelSerializer):
    ipv4addr = serializers.SerializerMethodField('get_ipv4')
    ipv6addr = serializers.SerializerMethodField('get_ipv6')

    def get_ipv4(self, i):
        return str(i.ipv4)

    def get_ipv6(self, i):
        return str(i.ipv6)

    class Meta:
        model = Instance
        fields = ['id', 'name', 'description', 'status', 'owner', 'access_method', 'boot_menu', 'pw', 'is_base',
                    'lease', 'raw_data', 'cloud_init', 'ci_meta_data', 'ci_user_data', 'system', 'req_traits',
                    'has_agent', 'num_cores', 'ram_size', 'max_ram_size', 'arch', 'priority', 'disks', 'node', 'ipv4addr', 'ipv6addr']
        extra_kwargs = {
            'disks': {'required': False, 'allow_empty': True,},
            'req_traits': {'required': False, 'allow_empty': True,}
        }


class InterfaceSerializer(serializers.ModelSerializer):
    mac = serializers.SerializerMethodField('get_mac')
    ipv4 = serializers.SerializerMethodField('get_ipv4')
    ipv6 = serializers.SerializerMethodField('get_ipv6')

    def get_mac(self, i):
        return str(i.mac)

    def get_ipv4(self, i):
        return str(i.ipv4)

    def get_ipv6(self, i):
        return str(i.ipv6)

    class Meta:
        model = Interface
        fields = ['id', 'vlan', 'host', 'instance', 'model', 'host', 'mac', 'ipv4', 'ipv6']


class VlanSerializer(serializers.ModelSerializer):
    class Meta:
        model = Vlan
        fields = ['id', 'vid', 'name', 'description', 'comment', 'domain']


class CreateDiskSerializer(serializers.Serializer):
    size = serializers.CharField(max_length=50)
    name = serializers.CharField(max_length=100)


class ResizeDiskSerializer(serializers.Serializer):
    size = serializers.CharField(max_length=50)
    disk = serializers.IntegerField()

class DownloadDiskSerializer(serializers.Serializer):
    url = serializers.CharField(max_length=500)
    name = serializers.CharField(max_length=100)

class CreateTemplateSerializer(serializers.Serializer):
    name = serializers.CharField(max_length=100)

class DestroyDiskSerializer(serializers.Serializer):
    disk = serializers.IntegerField()
    instance = serializers.IntegerField(required=False)

    class Meta:
        extra_kwargs = {'instance': {'required': False, 'allow_null': True}}

class AddPortSerializer(serializers.Serializer):
    type = serializers.CharField(max_length=5)
    port_destination = serializers.IntegerField()
    port_source = serializers.IntegerField(required=False)
    forwarding = serializers.BooleanField(required=False)

class VMDeploySerializer(serializers.Serializer):
    node = serializers.IntegerField(required=False)

    class Meta:
        extra_kwargs = {'node': {'required': False, 'allow_null': True}}