# register a signal do update permissions every migration.
# This is based on app django_extensions update_permissions command

from django.db.models.signals import post_migrate


def update_permissions_after_migration(sender, **kwargs):
    """
    Update app permission just after every migration.
    This is based on app django_extensions update_permissions
    management command.
    """

    from django.conf import settings
    from django.apps import apps
    from django.contrib.auth.management import create_permissions
    v = 2 if settings.DEBUG else 0
    create_permissions(sender, v, apps.get_models())


post_migrate.connect(update_permissions_after_migration)
