from celery import Celery
import serializers
from kombu import Queue, Exchange
from os import getenv

QUEUE_NAME = "localhost.man" 
AMQP_URI = getenv('AMQP_URI')

celerym = Celery('agentman', broker=AMQP_URI)

celerym.config_from_object('celeryconfig')

celerym.conf.update(
    # Queue declaration
    CELERY_QUEUES=(
        Queue(
            QUEUE_NAME,
            Exchange('manager', type='direct'),
            routing_key='manager',
        ),
    ),
    task_protocol = 1,        # Celery 3 compatibility


    # ROUTING: which task which queue / exchange / routing_key
    CELERY_ROUTES={
        'vm.tasks.local_agent_tasks.renew': {
            'queue': QUEUE_NAME,
            'exchange': 'manager',
            'routing_key': 'manager',
        },
        'vm.tasks.local_agent_tasks.agent_started': {
            'queue': QUEUE_NAME,
            'exchange': 'manager',
            'routing_key': 'manager',
        },
        'vm.tasks.local_agent_tasks.agent_stopped': {
            'queue': QUEUE_NAME,
            'exchange': 'manager',
            'routing_key': 'manager',
        },
        'vm.tasks.local_agent_tasks.agent_ok': {
            'queue': QUEUE_NAME,
            'exchange': 'manager',
            'routing_key': 'manager',
        },
    },
)

@celerym.task(name='vm.tasks.local_agent_tasks.renew')
def renew(vm):
    pass


@celerym.task(name='vm.tasks.local_agent_tasks.agent_started')
def agent_started(vm, version, system):
    pass


@celerym.task(name='vm.tasks.local_agent_tasks.agent_stopped')
def agent_stopped(vm):
    pass


@celerym.task(name='vm.tasks.local_agent_tasks.agent_ok')
def agent_ok(vm):
    pass
