# serializers.py  
from kombu.serialization import register, enable_insecure_serializers, pickle_protocol
import pickle
import logging

# PROTOKOLL 2 → Py2.7 is képes lesz deszerializálni
pickle_protocol = 2

logger = logging.getLogger(__name__)

def pickle_v2_dumps(obj):
    logger.debug("pickle_v2_dumps CALLED type=%r repr=%r", type(obj), repr(obj))
    return pickle.dumps(obj, protocol=2)

def pickle_v2_loads(s):
    logger.debug("pickle_v2_loads CALLED len=%r", len(s))
    return pickle.loads(s)

register(
    'pickle_v2',
    pickle_v2_dumps,
    pickle_v2_loads,
    content_type='application/x-pickle',
    content_encoding='binary',
)

#enable_insecure_serializers()

