# Open urls in default web browser provided by circle agent
# Part of CIRCLE project http://circlecloud.org/
# Should be in autostart and run by the user logged in

import logging
import sys
from os.path import join
from os import environ
from utils import setup_logging
from windows.winutils import update_component, create_autostart_task
from notify import run_client, get_temp_dir

workdir = r"C:\circle" 
comp_name = "circle-notify"

if getattr(sys, "frozen", False):
    file = os.path.join(workdir, comp_name)
    logger = setup_logging(logfile=file + ".log") 
else: 
    logger = logging.getLogger()

level = environ.get('LOGLEVEL', 'INFO')
logger.setLevel(level)

logger.info("Update check: %s in %s", comp_name + ".exe", workdir)
update = update_component(comp_name, workdir, service_fn=create_autostart_task)
logger.info("Update status: %s", update)
if update == "exit":
    sys.exit(1)


if __name__ == '__main__':
    run_client()
